/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Tools {
    public static String replaceStrings(String text, Hashtable table) {
        String wb = new String(text);
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String searchFor = (String)e.nextElement();
            String replaceBy = (String)table.get(searchFor);
            wb = Tools.replaceString(wb, searchFor, replaceBy);
        }
        return wb;
    }

    public static String replaceString(String text, String searchFor, String replaceBy) {
        StringBuffer wb = new StringBuffer(text);
        if (text != null && searchFor != null) {
            int start;
            if (replaceBy == null) {
                replaceBy = "";
            }
            int pos = 0;
            while (pos < wb.length() && (start = wb.toString().indexOf(searchFor, pos)) != -1) {
                int end = start + searchFor.length();
                wb.replace(start, end, replaceBy);
                pos = start + replaceBy.length();
            }
        }
        return wb.toString();
    }

    public static Vector getTokens(String list) {
        Vector<String> result = new Vector<String>();
        StringTokenizer st = new StringTokenizer(list);
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    public static String readFile(String filename) throws IOException {
        int res;
        StringBuffer wb = new StringBuffer();
        File file = new File(filename);
        System.out.println("Tools.readFile(): file.getAbsolutePath()=" + file.getAbsolutePath());
        FileReader in = new FileReader(file);
        char[] cbuf = new char[1];
        while ((res = in.read(cbuf, 0, 1)) != -1) {
            wb.append(cbuf);
        }
        in.close();
        return wb.toString();
    }

    public static void writeFile(String filename, String text) throws IOException {
        File file = new File(filename);
        System.out.println("Tools.writeFile(): file.getAbsolutePath()=" + file.getAbsolutePath());
        FileWriter out = new FileWriter(file);
        out.write(text, 0, text.length());
        out.flush();
        out.close();
    }

    public static Hashtable convertTableToHTML(Hashtable table) {
        Hashtable<String, String> wh = new Hashtable<String, String>();
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)table.get(key);
            String convertedValue = Tools.convertTextToHtml(value);
            wh.put(key, convertedValue);
        }
        return wh;
    }

    public static String convertTextToHtml(String text) {
        text = Tools.replaceString(text, "\n\n", "<P>");
        text = Tools.replaceString(text, "\n", "<BR>");
        return text;
    }

    public static Hashtable convertTableToText(Hashtable table) {
        Hashtable<String, String> wh = new Hashtable<String, String>();
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)table.get(key);
            String convertedValue = Tools.convertHtmlToText(value);
            wh.put(key, convertedValue);
        }
        return wh;
    }

    public static String convertHtmlToText(String text) {
        text = Tools.replaceString(text, "<P>", "\n\n");
        text = Tools.replaceString(text, "<BR>", "\n");
        return text;
    }

    public static String getKeyValuePairs(Hashtable table) {
        StringBuffer b = new StringBuffer();
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)table.get(key);
            b.append(key + "=" + value + "\n");
        }
        return b.toString();
    }

    public static Date getTime() {
        return Calendar.getInstance().getTime();
    }

    public static String encodeURL(String string) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char code = c;
            if (code >= '\u0000' && code <= '\u001f') {
                code = ' ';
            }
            String encode = code == ' ' ? "+" : (code >= '0' && code <= '9' || code >= 'A' && code <= 'Z' || code >= 'a' && code <= 'z' ? new Character(c).toString() : "%" + Integer.toHexString(code).toUpperCase());
            result.append(encode);
        }
        return result.toString();
    }

    public static String decodeURL(String string) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            String decode;
            char c;
            char code = c = string.charAt(i);
            if (c == '+') {
                decode = " ";
            } else if (c == '%') {
                String hexCode = string.substring(i + 1, i + 3).toLowerCase();
                int v = Integer.parseInt(hexCode, 16);
                char dc = (char)v;
                decode = new Character(dc).toString();
                i += 2;
            } else {
                decode = new Character(c).toString();
            }
            result.append(decode);
        }
        return result.toString();
    }

    public static boolean isValidName(String name) {
        return true;
    }
}

