/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal.util;

public class RFIDTools
implements Cloneable {
    public static final int SERIAL_NR_SIZE = 8;
    public static final int TAG_IT_HF = 1;
    public static final int ISO_15693 = 3;
    byte[] mySerialNr = new byte[8];
    int transponterType = 0;
    int dataSotageFamilyID = 0;

    public static String hexByte(int b) {
        String h = "0123456789ABCDEF";
        return "" + h.charAt((b & 0xF0) >> 4) + h.charAt(b & 0xF);
    }

    public static String getData(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sb.append(RFIDTools.hexByte(data[i]));
        }
        return sb.toString();
    }

    public static String getDataWithSpace(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sb.append(RFIDTools.hexByte(data[i]) + " ");
        }
        return sb.toString().trim();
    }

    public static String getDataWithSpaceLength(byte[] data, int l) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < l && i < data.length; ++i) {
            sb.append(RFIDTools.hexByte(data[i]) + " ");
        }
        return sb.toString().trim();
    }

    public static String getChar(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sb.append((char)data[i]);
        }
        return sb.toString();
    }

    public static String getSerialFromByteArray(byte[] snr, int offset) {
        byte[] mySerialNr = new byte[8];
        for (int i = 0; i < 8; ++i) {
            mySerialNr[i] = snr[offset + i];
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mySerialNr.length; ++i) {
            sb.append(RFIDTools.hexByte(mySerialNr[i]));
        }
        return sb.toString().trim();
    }

    public RFIDTools(byte[] snr, int offset, int type, int dsfID) {
        for (int i = 0; i < 8; ++i) {
            this.mySerialNr[i] = snr[offset + i];
        }
        this.transponterType = type;
        this.dataSotageFamilyID = dsfID;
    }

    public byte[] getSNR() {
        return this.mySerialNr;
    }

    public String getSerialWithSpace() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.mySerialNr.length; ++i) {
            sb.append(RFIDTools.hexByte(this.mySerialNr[i]) + " ");
        }
        return sb.toString().trim();
    }

    public String getSerial() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.mySerialNr.length; ++i) {
            sb.append(RFIDTools.hexByte(this.mySerialNr[i]));
        }
        return sb.toString().trim();
    }

    public boolean hasSNR(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (this.mySerialNr[i] == data[i]) continue;
            return false;
        }
        return true;
    }

    public boolean hasSNR(byte[] data, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (this.mySerialNr[i] == data[offset + i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        RFIDTools tagCopy = new RFIDTools((byte[])this.mySerialNr.clone(), 0, this.transponterType, this.dataSotageFamilyID);
        return tagCopy;
    }

    public String toString() {
        return "[" + this.getSerial() + "]";
    }

    public boolean equals(Object tag) {
        if (tag instanceof RFIDTools) {
            return ((RFIDTools)tag).hasSNR(this.mySerialNr);
        }
        return false;
    }

    public int hashCode() {
        long v = 0L;
        for (int i = this.mySerialNr.length - 1; i >= 0; --i) {
            v = 256L * v + (long)(this.mySerialNr[i] & 0xFF);
        }
        return (int)v;
    }
}

