/*
 * Decompiled with CFR 0.152.
 */
package org.fosstrak.hal;

import java.io.UnsupportedEncodingException;

public class UnsignedByteArray {
    protected byte[] bytes;

    public UnsignedByteArray(byte[] bytes) {
        this.bytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            this.bytes[i] = bytes[i];
        }
    }

    public UnsignedByteArray(String bytes) {
        this.bytes = UnsignedByteArray.hexStringToByteArray(bytes);
    }

    protected byte[] getInternalByteArray() {
        return this.bytes;
    }

    public byte[] toByteArray() {
        byte[] ba = new byte[this.bytes.length];
        for (int i = 0; i < this.bytes.length; ++i) {
            ba[i] = this.bytes[i];
        }
        return ba;
    }

    public String toString() {
        return UnsignedByteArray.byteArrayToHexString(this.bytes);
    }

    public Object clone() {
        byte[] copy = this.toByteArray();
        UnsignedByteArray bbCopy = new UnsignedByteArray(copy);
        return bbCopy;
    }

    public boolean equals(Object o) {
        if (o instanceof UnsignedByteArray) {
            return ((UnsignedByteArray)o).bytes.equals(this.bytes);
        }
        return false;
    }

    public int hashCode() {
        long v = 0L;
        for (int i = this.bytes.length - 1; i >= 0; --i) {
            v = 256L * v + (long)(this.bytes[i] & 0xFF);
        }
        return (int)v;
    }

    public static String byteToHexString(byte b) {
        byte i = b;
        String h = "0123456789ABCDEF";
        return "" + h.charAt((i & 0xF0) >> 4) + h.charAt(i & 0xF);
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            sb.append(UnsignedByteArray.byteToHexString(byteArray[i]));
        }
        return sb.toString();
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] byteArray = new byte[len / 2];
        if (len % 2 != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < len / 2; ++i) {
            byte byteValue;
            String byteString = hexString.substring(i * 2, i * 2 + 2);
            Integer intValue = new Integer(Integer.parseInt(byteString, 16));
            byteArray[i] = byteValue = intValue.byteValue();
        }
        return byteArray;
    }

    public static byte[] numberToByteArray(long n) {
        byte[] ba = new byte[8];
        for (int s = 0; s < 8; ++s) {
            byte b;
            ba[s] = b = (byte)(n >> (7 - s) * 8 & 0xFFL);
        }
        return ba;
    }

    public static byte[] numberToByteArray(int n) {
        byte[] ba = new byte[4];
        for (int s = 0; s < 4; ++s) {
            byte b;
            ba[s] = b = (byte)(n >> (3 - s) * 8 & 0xFF);
        }
        return ba;
    }

    public static byte[] numberToByteArray(short n) {
        byte[] ba = new byte[2];
        for (int s = 0; s < 2; ++s) {
            byte b;
            ba[s] = b = (byte)(n >> (1 - s) * 8 & 0xFF);
        }
        return ba;
    }

    public static boolean equalsRegion(byte[] firstArray, int firstOffset, byte[] secondArray, int secondOffset, int length) {
        int secondIndex;
        int firstIndex = firstOffset;
        for (secondIndex = secondOffset; firstIndex < firstArray.length && secondIndex < secondArray.length && firstIndex < firstOffset + length && secondIndex < secondOffset + length && firstArray[firstIndex] == secondArray[secondIndex]; ++firstIndex, ++secondIndex) {
        }
        return firstIndex == firstOffset + length && secondIndex == secondOffset + length;
    }

    public static boolean equalsRegion(byte[] firstArray, int firstOffset, byte[] secondArray) {
        return UnsignedByteArray.equalsRegion(firstArray, firstOffset, secondArray, 0, secondArray.length);
    }

    public static int compareRegion(byte[] firstArray, int firstOffset, byte[] secondArray, int secondOffset, int length) {
        int firstIndex = firstOffset;
        for (int secondIndex = secondOffset; firstIndex < firstArray.length && secondIndex < secondArray.length && firstIndex < firstOffset + length && secondIndex < secondOffset + length; ++firstIndex, ++secondIndex) {
            int res = UnsignedByteArray.compare(firstArray[firstIndex], secondArray[secondIndex]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static int compare(byte first, byte second) {
        int f = first & 0xFF;
        int s = second & 0xFF;
        if (f < s) {
            return -1;
        }
        if (f == s) {
            return 0;
        }
        return 1;
    }

    public static byte[] getRegion(byte[] array, int offset, int length) {
        byte[] region = new byte[length];
        for (int i = 0; i < length; ++i) {
            region[i] = array[i + offset];
        }
        return region;
    }

    public static void replaceRegion(byte[] firstArray, int offset, byte[] secondArray) {
        for (int i = 0; i < secondArray.length; ++i) {
            firstArray[i + offset] = secondArray[i];
        }
    }

    public static void replaceRegion(byte[] firstArray, int firstOffset, byte[] secondArray, int secondOffset, int length) {
        for (int i = 0; i < length; ++i) {
            firstArray[firstOffset + i] = secondArray[secondOffset + i];
        }
    }

    public static byte[] stringConverter(String string) {
        byte[] defaultBytes = null;
        byte[] utf8Bytes = null;
        System.out.println(System.getProperty("file.encoding"));
        String original = new String(string);
        System.out.println("original = " + original);
        System.out.println();
        try {
            utf8Bytes = original.getBytes("UTF8");
            defaultBytes = original.getBytes();
            String roundTrip = new String(utf8Bytes, "UTF8");
            System.out.println("roundTrip = " + roundTrip);
            System.out.println();
            System.out.println();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return defaultBytes;
    }
}

