/*
 * Decompiled with CFR 0.152.
 */
package org.flowstep.mongo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.bson.conversions.Bson;
import org.flowstep.mongo.model.StepSortType;
import org.flowstep.mongo.model.serialize.StepSortTypeDeserializer;
import org.flowstep.mongo.model.serialize.StepSortTypeSerializer;

public class StepSort {
    private String fieldName;
    @JsonSerialize(using=StepSortTypeSerializer.class)
    @JsonDeserialize(using=StepSortTypeDeserializer.class)
    private StepSortType sorting;

    public StepSort() {
    }

    public StepSort(StepSort stepSort) {
        this.fieldName = stepSort.fieldName;
        this.sorting = stepSort.sorting;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public StepSortType getSorting() {
        return this.sorting;
    }

    public void setSorting(StepSortType sorting) {
        this.sorting = sorting;
    }

    @JsonIgnore
    public Bson getSort() {
        return this.sorting.getSort(this.fieldName);
    }

    @JsonIgnore
    public Bson getSort(String prefix) {
        return this.sorting.getSort(prefix + this.fieldName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StepSort stepSort = (StepSort)o;
        return new EqualsBuilder().append((Object)this.fieldName, (Object)stepSort.fieldName).append((Object)this.sorting, (Object)stepSort.sorting).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.fieldName).append((Object)this.sorting).toHashCode();
    }
}

