/*
 * Decompiled with CFR 0.152.
 */
package org.flowstep.mongo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.flowstep.core.CloneableList;
import org.flowstep.core.FilterDependencyLink;
import org.flowstep.core.model.step.FlowStepComponent;
import org.flowstep.core.model.step.FlowStepData;
import org.flowstep.mongo.model.Group;
import org.flowstep.mongo.model.HasStepFilters;
import org.flowstep.mongo.model.MongoStepFilter;
import org.flowstep.mongo.model.StepFilterGroup;
import org.flowstep.mongo.model.StepSort;
import org.springframework.stereotype.Component;

@Component
public class MongoStep
extends FlowStepData
implements HasStepFilters,
FlowStepComponent {
    @JsonProperty(value="filterGroups")
    private CloneableList<StepFilterGroup> filterGroups;
    @JsonProperty(value="sort")
    private CloneableList<StepSort> sort;
    @JsonProperty(value="group")
    private Group group;

    public MongoStep() {
        this.filterGroups = new CloneableList();
        this.sort = new CloneableList();
    }

    public MongoStep(MongoStep step) {
        super((FlowStepData)step);
        this.filterGroups = new CloneableList(step.filterGroups);
        if (step.sort != null) {
            this.sort = new CloneableList(step.sort);
        }
        if (step.group != null) {
            this.group = new Group(step.group);
        }
    }

    public CloneableList<StepFilterGroup> getFilterGroups() {
        return this.filterGroups;
    }

    public void setFilterGroups(CloneableList<StepFilterGroup> filterGroups) {
        this.filterGroups = filterGroups;
    }

    public List<String> getStepDependencies() {
        return this.getAllFilters().map(filter -> new FilterDependencyLink(filter.getStep()).getStepName()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public CloneableList<StepSort> getSort() {
        return this.sort;
    }

    public MongoStep setSort(CloneableList<StepSort> sort) {
        this.sort = sort;
        return this;
    }

    public Group getGroup() {
        return this.group;
    }

    public MongoStep setGroup(Group group) {
        this.group = group;
        return this;
    }

    @Override
    @JsonIgnore
    public Stream<MongoStepFilter> getAllFilters() {
        return this.filterGroups.stream().flatMap(filterGroup -> filterGroup.getFilters().stream());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoStep mongoStep = (MongoStep)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.filterGroups, mongoStep.filterGroups).append(this.sort, mongoStep.sort).append((Object)this.group, (Object)mongoStep.group).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.filterGroups).append(this.sort).append((Object)this.group).toHashCode();
    }
}

