/*
 * Decompiled with CFR 0.152.
 */
package org.flowstep.mongo.model;

import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.bson.conversions.Bson;
import org.flowstep.core.factory.FlowTransformFactory;
import org.flowstep.core.transform.HasFlowTransform;
import org.flowstep.mongo.model.MongoStepFilter;

public enum FilterCondition {
    GT(filter -> Filters.gt((String)filter.getFieldName(), (Object)filter.getFieldValue())),
    GTE(filter -> Filters.gte((String)filter.getFieldName(), (Object)filter.getFieldValue())),
    EXISTS(filter -> Filters.exists((String)filter.getFieldName(), (boolean)((Boolean)((HasFlowTransform)FlowTransformFactory.FILTER_BOOLEAN.get()).transform(filter.getFieldValue())))),
    LT(filter -> Filters.lt((String)filter.getFieldName(), (Object)filter.getFieldValue())),
    LTE(filter -> Filters.lte((String)filter.getFieldName(), (Object)filter.getFieldValue())),
    NE(filter -> Filters.ne((String)filter.getFieldName(), (Object)filter.getFieldValue())),
    IN(filter -> Filters.in((String)filter.getFieldName(), (Iterable)((List)((HasFlowTransform)FlowTransformFactory.FILTER_SET_OF_INTEGER.get()).transform(filter.getFieldValue())))),
    NIN(filter -> Filters.nin((String)filter.getFieldName(), (Object[])new Object[]{((HasFlowTransform)FlowTransformFactory.FILTER_SET_OF_STRING.get()).transform(filter.getFieldValue())})),
    SIZE(filter -> Filters.size((String)filter.getFieldName(), (int)((Integer)((HasFlowTransform)FlowTransformFactory.FILTER_INTEGER.get()).transform(filter.getFieldValue())))),
    REGEX(filter -> Filters.regex((String)filter.getFieldName(), (Pattern)Pattern.compile(filter.getFieldValue() != null ? String.valueOf(filter.getFieldValue()) : "", 2))),
    EQ(filter -> {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)String.valueOf(filter.getFieldValue()), (CharSequence[])new CharSequence[]{"true", "false"})) {
            return Filters.eq((String)filter.getFieldName(), (Object)((Boolean)((HasFlowTransform)FlowTransformFactory.FILTER_BOOLEAN.get()).transform(filter.getFieldValue())));
        }
        return Filters.eq((String)filter.getFieldName(), (Object)((String)filter.getFieldValue()));
    });

    private final Function<MongoStepFilter, Bson> filterFunction;

    private FilterCondition(Function<MongoStepFilter, Bson> filterFunction) {
        this.filterFunction = filterFunction;
    }

    public Bson getFilter(MongoStepFilter filter) {
        return this.filterFunction.apply(filter);
    }
}

