/*
 * Decompiled with CFR 0.152.
 */
package org.flowstep.mongo;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.flowstep.core.FilterDependencyLink;
import org.flowstep.core.context.FlowPackageContext;
import org.flowstep.core.model.step.FlowPackage;
import org.flowstep.core.model.step.FlowStepData;
import org.flowstep.core.processor.FlowPackageProcessor;
import org.flowstep.core.processor.FlowProcessorType;
import org.flowstep.mongo.model.HasStepFilters;
import org.springframework.stereotype.Component;

@Component
public class StepFilterDependenciesProcessor
implements FlowPackageProcessor {
    public FlowProcessorType getType() {
        return FlowProcessorType.PREPROCESSOR;
    }

    public boolean process(FlowPackageContext context) {
        this.processPrimaryKeys(context.getStepPackage());
        return true;
    }

    public Set<String> getFilterDependencies(FlowPackage stepPackage) {
        HashSet<String> result = new HashSet<String>();
        stepPackage.getStepGroups().forEach(stepGroup -> stepGroup.getSteps().forEach(step -> {
            if (step instanceof HasStepFilters) {
                HasStepFilters dataStep = (HasStepFilters)step;
                dataStep.getAllFilters().filter(filter -> StringUtils.isNotBlank((CharSequence)filter.getStep())).forEach(filter -> result.add(filter.getStep()));
            }
        }));
        return result;
    }

    private void processPrimaryKeys(FlowPackage stepPackage) {
        Set<String> filterDependencies = this.getFilterDependencies(stepPackage);
        if (!filterDependencies.isEmpty()) {
            filterDependencies.forEach(primaryKeyLink -> {
                FilterDependencyLink link = new FilterDependencyLink(primaryKeyLink);
                if (link.isCorrect()) {
                    stepPackage.getStepGroups().stream().flatMap(group -> group.getSteps().stream()).forEach(step -> {
                        if (step instanceof FlowStepData) {
                            this.trySetPrimaryKey((FlowStepData)step, link);
                        }
                    });
                }
            });
        }
    }

    private void trySetPrimaryKey(FlowStepData dataStep, FilterDependencyLink link) {
        if (dataStep.getId().equals(link.getStepName())) {
            dataStep.getFields().stream().filter(field -> field.getName().equals(link.getFieldName())).findFirst().ifPresent(field -> {
                field.setPrimaryKey(true);
                dataStep.setHasPrimaryKey(true);
            });
        }
    }
}

