/*
 * Decompiled with CFR 0.152.
 */
package org.flowstep.mongo;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.flowstep.core.DataProviderException;
import org.flowstep.core.connection.EnvironmentConnection;
import org.flowstep.core.context.FlowNewStepContext;
import org.flowstep.core.context.FlowStepContext;
import org.flowstep.core.model.environment.EnvironmentItemSettings;
import org.flowstep.core.processor.FlowStepDataProcessor;
import org.flowstep.mongo.model.MongoEnvironment;
import org.flowstep.mongo.model.MongoStep;
import org.flowstep.mongo.model.MongoStepFilter;
import org.flowstep.mongo.model.StepSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class MongoNewStepProcessor
implements FlowStepDataProcessor<MongoEnvironment, MongoStep> {
    private static final Logger logger = LoggerFactory.getLogger(MongoNewStepProcessor.class);

    public EnvironmentConnection getConnection(MongoEnvironment environmentItemSettings) {
        return new EnvironmentConnection((Object)this.mongoTemplate(environmentItemSettings), (EnvironmentItemSettings)environmentItemSettings);
    }

    public Iterator<Document> process(FlowNewStepContext<MongoStep> flowStepContext, EnvironmentConnection connection) {
        if (connection != null) {
            try {
                MongoEnvironment mongoEnvironment = (MongoEnvironment)connection.getEnvironmentItemSettings();
                MongoTemplate mongoTemplate = (MongoTemplate)connection.getConnectionTemplate();
                MongoCollection collection = mongoTemplate.getCollection(mongoEnvironment.getCollection());
                FlowStepContext stepContext = new FlowStepContext(flowStepContext.getStepPackageContext(), flowStepContext.getStepGroup(), flowStepContext.getStep());
                Bson filter = this.buildAggregateFilter((MongoStep)flowStepContext.getStep(), stepContext);
                Bson sort = this.buildFindSorts((MongoStep)flowStepContext.getStep());
                Bson projection = this.buildProjection((MongoStep)flowStepContext.getStep());
                return this.retrieveData((MongoStep)flowStepContext.getStep(), (MongoCollection<Document>)collection, filter, projection, sort, ((MongoStep)flowStepContext.getStep()).getLimit()).iterator();
            }
            catch (DataAccessException e) {
                throw new DataProviderException("Data Provider Exception", (Throwable)e);
            }
        }
        logger.error("Error: couldn't find connection for environment: {}", (Object)((MongoStep)flowStepContext.getStep()).getEnvironment());
        return null;
    }

    private List<Bson> buildGroupPipeline(MongoStep step, Bson filter) {
        Document aggregateFields = new Document();
        step.getFields().forEach(field -> {
            String fieldName = field.getId().replace(".", "");
            String fieldKey = "$" + field.getId();
            aggregateFields.append(fieldName, (Object)fieldKey);
        });
        BsonField aggregator = step.getGroup().getGroupOperator();
        ArrayList<Bson> aggregatedParams = new ArrayList<Bson>();
        aggregatedParams.add(Aggregates.match((Bson)filter));
        aggregatedParams.add(Aggregates.group((Object)aggregateFields, (BsonField[])new BsonField[]{aggregator}));
        if (!step.getSort().isEmpty()) {
            aggregatedParams.add(Aggregates.sort((Bson)this.getAggregatedSorts(step)));
        }
        return aggregatedParams;
    }

    private Bson buildFindSorts(MongoStep step) {
        List sorts = step.getSort().stream().map(StepSort::getSort).collect(Collectors.toList());
        return Sorts.orderBy(sorts);
    }

    private Bson getAggregatedSorts(MongoStep step) {
        String prefix = "_id";
        String groupName = step.getGroup().getFieldName();
        List sorts = step.getSort().stream().map(sort -> {
            String currentPrefix = sort.getFieldName().equalsIgnoreCase(groupName) ? "" : prefix;
            return sort.getSort(currentPrefix);
        }).collect(Collectors.toList());
        return Sorts.orderBy(sorts);
    }

    private Bson buildProjection(MongoStep step) {
        List ids = step.getFields().stream().map(field -> field.getId().contains(".[") ? field.getId().substring(0, field.getId().indexOf(".[")) : field.getId()).collect(Collectors.toList());
        return Projections.fields((Bson[])new Bson[]{Projections.include(ids)});
    }

    private Bson buildAggregateFilter(MongoStep step, FlowStepContext stepContext) {
        ArrayList filterGroups = new ArrayList();
        step.getFilterGroups().forEach(group -> {
            Bson groupedFilter = group.getType().getOperatorFunction().apply(group.getFilters().stream().map(filter -> {
                filter.processValueFromTransform(stepContext);
                return filter.getCondition().getFilter((MongoStepFilter)((Object)((Object)filter)));
            }).collect(Collectors.toList()));
            filterGroups.add(groupedFilter);
        });
        return filterGroups.size() > 1 ? Filters.or(filterGroups) : Filters.and(filterGroups);
    }

    private Iterable<Document> retrieveData(MongoStep step, MongoCollection<Document> collection, Bson filter, Bson projection, Bson sort, Integer limit) {
        if (step.getGroup() != null) {
            List<Bson> groupPipeline = this.buildGroupPipeline(step, filter);
            return collection.aggregate(groupPipeline).allowDiskUse(Boolean.valueOf(true));
        }
        FindIterable findResults = collection.find(filter).projection(projection).sort(sort).allowDiskUse(Boolean.valueOf(true)).noCursorTimeout(true);
        if (limit > 0) {
            findResults.limit(limit.intValue());
        }
        return findResults;
    }

    private MongoClient mongoClient(MongoEnvironment settings) {
        return MongoClients.create((String)settings.getUri());
    }

    private MongoTemplate mongoTemplate(MongoEnvironment settings) {
        return new MongoTemplate(this.mongoClient(settings), settings.getDatabase());
    }
}

