/*
 * Decompiled with CFR 0.152.
 */
package org.flowstep.mongo;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.flowstep.core.FilterDependencyLink;
import org.flowstep.core.context.FlowNewStepContext;
import org.flowstep.core.model.step.FlowStep;
import org.flowstep.core.model.step.FlowStepData;
import org.flowstep.core.processor.FlowProcessorType;
import org.flowstep.core.processor.FlowStepProcessor;
import org.flowstep.mongo.model.HasStepFilters;
import org.springframework.stereotype.Component;

@Component
public class FilterNewDependenciesPreProcessor
implements FlowStepProcessor<FlowStep> {
    public FlowProcessorType getType() {
        return FlowProcessorType.PREPROCESSOR;
    }

    public boolean process(FlowNewStepContext<FlowStep> flowStepContext) {
        FlowStepData dataStep = (FlowStepData)flowStepContext.getStep();
        if (dataStep instanceof HasStepFilters) {
            HasStepFilters filters = (HasStepFilters)dataStep;
            filters.getAllFilters().filter(filter -> StringUtils.isNotBlank((CharSequence)filter.getStep())).forEach(filter -> {
                FilterDependencyLink link = new FilterDependencyLink(filter.getStep());
                if (link.isCorrect()) {
                    ArrayList cashedSet = new ArrayList(flowStepContext.getStepPackageContext().getCachedSet(link));
                    filter.setFieldValue(cashedSet);
                }
            });
        }
        return true;
    }
}

