/*
 *
 *  Copyright 2022 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.flowstep.mongo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.bson.conversions.Bson;
import org.flowstep.mongo.model.serialize.StepSortTypeDeserializer;
import org.flowstep.mongo.model.serialize.StepSortTypeSerializer;

public class StepSort {
    private String fieldName;
    @JsonSerialize(using = StepSortTypeSerializer.class)
    @JsonDeserialize(using = StepSortTypeDeserializer.class)
    private StepSortType sorting;

    public StepSort() {
    }

    public StepSort(StepSort stepSort) {
        fieldName = stepSort.fieldName;
        sorting = stepSort.sorting;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public StepSortType getSorting() {
        return sorting;
    }

    public void setSorting(StepSortType sorting) {
        this.sorting = sorting;
    }

    @JsonIgnore
    public Bson getSort() {
        return sorting.getSort(fieldName);
    }

    @JsonIgnore
    public Bson getSort(String prefix) {
        return sorting.getSort(prefix + fieldName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        StepSort stepSort = (StepSort) o;

        return new EqualsBuilder().append(fieldName, stepSort.fieldName).append(sorting, stepSort.sorting).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(fieldName).append(sorting).toHashCode();
    }
}
