/*
 *
 *  Copyright 2022 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.flowstep.mongo.model;

import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.BsonField;

import java.util.function.Function;

public enum StepGroupType {
    AVG(fieldName -> Accumulators.avg(fieldName, 1)),
    FIRST(fieldName -> Accumulators.first(fieldName, 1)),
    LAST(fieldName -> Accumulators.last(fieldName, 1)),
    MAX(fieldName -> Accumulators.max(fieldName, 1)),
    MIN(fieldName -> Accumulators.min(fieldName, 1)),
    SUM(fieldName -> Accumulators.sum(fieldName, 1));

    private Function<String, BsonField> function;

    StepGroupType(Function<String, BsonField> function) {
        this.function = function;
    }

    public BsonField getGroupOperator(String fieldName) {
        return function.apply(fieldName);
    }

}
