/*
 *
 *  Copyright 2022 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.flowstep.mongo.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.flowstep.core.CloneableList;
import org.flowstep.mongo.model.serialize.StepFilterOperatorDeserializer;
import org.flowstep.mongo.model.serialize.StepFilterOperatorSerializer;

public class StepFilterGroup {

    @JsonSerialize(using = StepFilterOperatorSerializer.class)
    @JsonDeserialize(using = StepFilterOperatorDeserializer.class)
    private StepFilterOperator type = StepFilterOperator.AND;
    private CloneableList<MongoStepFilter> filters;

    public StepFilterGroup() {
        filters = new CloneableList<>();
    }

    public StepFilterGroup(StepFilterGroup group) {
        this.type = group.type;
        this.filters = new CloneableList<>(group.filters);
    }

    public StepFilterOperator getType() {
        return type;
    }

    public StepFilterGroup setType(StepFilterOperator type) {
        this.type = type;
        return this;
    }

    public CloneableList<MongoStepFilter> getFilters() {
        return filters;
    }

    public StepFilterGroup setFilters(CloneableList<MongoStepFilter> filters) {
        this.filters = filters;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        StepFilterGroup that = (StepFilterGroup) o;

        return new EqualsBuilder().append(type, that.type).append(filters, that.filters).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(type).append(filters).toHashCode();
    }
}
