/*
 *
 *  Copyright 2022 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.flowstep.mongo.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.flowstep.core.model.StepFilter;
import org.flowstep.mongo.model.serialize.FilterConditionDeserializer;
import org.flowstep.mongo.model.serialize.FilterConditionSerializer;

public class MongoStepFilter extends StepFilter {
    @JsonDeserialize(using = FilterConditionDeserializer.class)
    @JsonSerialize(using = FilterConditionSerializer.class)
    private FilterCondition condition;

    public MongoStepFilter() {
        super();
    }

    public MongoStepFilter(MongoStepFilter filter) {
        super(filter);
        this.condition = filter.condition;
    }

    public FilterCondition getCondition() {
        return condition;
    }

    public MongoStepFilter setCondition(FilterCondition condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        MongoStepFilter that = (MongoStepFilter) o;

        return new EqualsBuilder().appendSuper(super.equals(o)).append(condition, that.condition).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(condition).toHashCode();
    }
}
