/*
 *
 *  Copyright 2022 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.flowstep.mongo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.mongodb.client.model.BsonField;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.flowstep.mongo.model.serialize.StepGroupTypeDeserializer;
import org.flowstep.mongo.model.serialize.StepGroupTypeSerializer;

public class Group {
    private String fieldName;

    @JsonSerialize(using = StepGroupTypeSerializer.class)
    @JsonDeserialize(using = StepGroupTypeDeserializer.class)
    private StepGroupType type;

    public Group() {
    }

    public Group(Group group) {
        fieldName = group.fieldName;
        type = group.type;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public StepGroupType getType() {
        return type;
    }

    public void setType(StepGroupType type) {
        this.type = type;
    }

    @JsonIgnore
    public BsonField getGroupOperator() {
        return type.getGroupOperator(fieldName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        Group group = (Group) o;

        return new EqualsBuilder().append(fieldName, group.fieldName).append(type, group.type).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(fieldName).append(type).toHashCode();
    }
}
