/*
 * Decompiled with CFR 0.152.
 */
package org.flowstep.mongo.transform;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import org.flowstep.core.FlowComponent;
import org.flowstep.core.context.FlowStepContext;
import org.flowstep.core.model.step.FlowStepComponent;
import org.flowstep.core.transform.FlowTransform;

@FlowComponent
public class DateFormat
implements FlowTransform,
FlowStepComponent {
    private String format = "yyyy-MM-dd HH:mm:ss.SSS'Z'";
    private String timeZone;
    @JsonIgnore
    private SimpleDateFormat simpleDateFormat;
    @JsonIgnore
    private DateTimeFormatter dateTimeFormatter;

    public String getFormat() {
        return this.format;
    }

    public DateFormat setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public DateFormat setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public void postConfigure() {
        this.simpleDateFormat = new SimpleDateFormat(this.format);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.format);
    }

    public Object transform(Object value, FlowStepContext context) {
        if (value instanceof Date) {
            if (this.timeZone != null) {
                this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.timeZone));
            }
            return this.simpleDateFormat.format(value);
        }
        if (value instanceof LocalDateTime) {
            if (this.timeZone != null) {
                this.dateTimeFormatter = this.dateTimeFormatter.withZone(ZoneId.of(this.timeZone));
            }
            return ((LocalDateTime)value).format(this.dateTimeFormatter);
        }
        return value;
    }
}

