/*
 *
 *  Copyright 2022 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.flowstep.mongo;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import org.flowstep.core.connection.ConnectionBuilder;
import org.flowstep.core.connection.EnvironmentConnection;
import org.flowstep.core.model.environment.EnvironmentItemSettings;
import org.flowstep.mongo.model.MongoEnvironment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class MongoConnectionBuilder implements ConnectionBuilder {

    @Override
    public boolean canBuildConnection(EnvironmentItemSettings settings) {
        return settings instanceof MongoEnvironment;
    }

    @Override
    public EnvironmentConnection buildConnection(EnvironmentItemSettings settings) {
        return new EnvironmentConnection(mongoTemplate((MongoEnvironment) settings), settings);
    }


    private MongoClient mongoClient(MongoEnvironment settings) {
        return MongoClients.create(settings.getUri());
    }

    public MongoTemplate mongoTemplate(MongoEnvironment settings) {
        return new MongoTemplate(mongoClient(settings), settings.getDatabase());
    }
}
