/*
 *
 *  Copyright 2022 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.flowstep.mongo;

import org.apache.commons.lang3.StringUtils;
import org.flowstep.core.FilterDependencyLink;
import org.flowstep.core.context.FlowPackageContext;
import org.flowstep.core.model.step.FlowGroup;
import org.flowstep.core.model.step.FlowStep;
import org.flowstep.core.model.step.FlowStepData;
import org.flowstep.core.processor.FlowProcessor;
import org.flowstep.core.processor.FlowProcessorType;
import org.flowstep.mongo.model.HasStepFilters;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class FilterDependenciesPreProcessor implements FlowProcessor {

    @Override
    public FlowProcessorType getType() {
        return FlowProcessorType.PREPROCESSOR;
    }

    @Override
    public boolean canProcess(FlowStep step) {
        return step instanceof FlowStepData;
    }

    @Override
    public boolean process(FlowGroup stepGroup, FlowStep step, FlowPackageContext stepPackageContext) {
        FlowStepData dataStep = (FlowStepData) step;

        if (dataStep instanceof HasStepFilters) {
            HasStepFilters filters = (HasStepFilters) dataStep;

            filters.getAllFilters()
                    .filter(filter -> StringUtils.isNotBlank(filter.getStep()))
                    .forEach(filter -> {
                        FilterDependencyLink link = new FilterDependencyLink(filter.getStep());

                        if (link.isCorrect()) {
                            List<Object> cashedSet = new ArrayList<>(stepPackageContext.getCachedSet(link));
                            filter.setFieldValue(cashedSet);
                        }
                    });
        }

        return true;
    }
}
