/*
 * Decompiled with CFR 0.152.
 */
package org.flowstep.mongo;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.flowstep.core.DataProviderException;
import org.flowstep.core.ExtractedRecord;
import org.flowstep.core.FlowDataProvider;
import org.flowstep.core.RecordFieldExtractor;
import org.flowstep.core.connection.EnvironmentConnection;
import org.flowstep.core.context.FlowPackageContext;
import org.flowstep.core.context.FlowStepContext;
import org.flowstep.core.model.step.FlowGroup;
import org.flowstep.core.model.step.FlowStep;
import org.flowstep.core.model.step.FlowStepData;
import org.flowstep.mongo.model.MongoEnvironment;
import org.flowstep.mongo.model.MongoStep;
import org.flowstep.mongo.model.MongoStepFilter;
import org.flowstep.mongo.model.StepSort;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoDataProvider
implements FlowDataProvider {
    private EnvironmentConnection connection;
    private FlowPackageContext stepPackageContext;
    private MongoStep step;
    private FlowGroup stepGroup;

    public MongoDataProvider setConnection(EnvironmentConnection connection) {
        this.connection = connection;
        return this;
    }

    public MongoDataProvider setStepPackageContext(FlowPackageContext stepPackageContext) {
        this.stepPackageContext = stepPackageContext;
        return this;
    }

    public MongoDataProvider setStep(MongoStep step) {
        this.step = step;
        return this;
    }

    public MongoDataProvider setStepGroup(FlowGroup stepGroup) {
        this.stepGroup = stepGroup;
        return this;
    }

    public void build() throws DataProviderException {
        try {
            MongoEnvironment mongoEnvironment = (MongoEnvironment)this.connection.getEnvironmentItemSettings();
            MongoTemplate mongoTemplate = (MongoTemplate)this.connection.getConnectionTemplate();
            MongoCollection collection = mongoTemplate.getCollection(mongoEnvironment.getCollection());
            FlowStepContext stepContext = new FlowStepContext(this.stepPackageContext, this.stepGroup, (FlowStep)this.step);
            Bson filter = this.buildAggregateFilter(this.step, stepContext);
            Bson sort = this.buildFindSorts(this.step);
            Bson projection = this.buildProjection(this.step);
            Iterable<Document> result = this.retrieveData((MongoCollection<Document>)collection, filter, projection, sort, this.step.getLimit());
            for (Document document : result) {
                this.saveRecord(this.step, (Map<String, Object>)document, stepContext, this.stepPackageContext);
            }
        }
        catch (DataAccessException e) {
            throw new DataProviderException("Data Provider Exception", (Throwable)e);
        }
    }

    private List<Bson> buildGroupPipeline(MongoStep step, Bson filter) {
        Document aggregateFields = new Document();
        step.getFields().forEach(field -> {
            String fieldName = field.getId().replace(".", "");
            String fieldKey = "$" + field.getId();
            aggregateFields.append(fieldName, (Object)fieldKey);
        });
        BsonField aggregator = step.getGroup().getGroupOperator();
        ArrayList<Bson> aggregatedParams = new ArrayList<Bson>();
        aggregatedParams.add(Aggregates.match((Bson)filter));
        aggregatedParams.add(Aggregates.group((Object)aggregateFields, (BsonField[])new BsonField[]{aggregator}));
        if (!step.getSort().isEmpty()) {
            aggregatedParams.add(Aggregates.sort((Bson)this.getAggregatedSorts(step)));
        }
        return aggregatedParams;
    }

    private Bson buildFindSorts(MongoStep step) {
        List sorts = step.getSort().stream().map(StepSort::getSort).collect(Collectors.toList());
        return Sorts.orderBy(sorts);
    }

    private Bson getAggregatedSorts(MongoStep step) {
        String prefix = "_id";
        String groupName = step.getGroup().getFieldName();
        List sorts = step.getSort().stream().map(sort -> {
            String currentPrefix = sort.getFieldName().equalsIgnoreCase(groupName) ? "" : prefix;
            return sort.getSort(currentPrefix);
        }).collect(Collectors.toList());
        return Sorts.orderBy(sorts);
    }

    private Bson buildProjection(MongoStep step) {
        List ids = step.getFields().stream().map(field -> field.getId().contains(".[") ? field.getId().substring(0, field.getId().indexOf(".[")) : field.getId()).collect(Collectors.toList());
        return Projections.fields((Bson[])new Bson[]{Projections.include(ids)});
    }

    private Bson buildAggregateFilter(MongoStep step, FlowStepContext stepContext) {
        ArrayList filterGroups = new ArrayList();
        step.getFilterGroups().forEach(group -> {
            Bson groupedFilter = group.getType().getOperatorFunction().apply(group.getFilters().stream().map(filter -> {
                filter.processValueFromTransform(stepContext);
                return filter.getCondition().getFilter((MongoStepFilter)((Object)((Object)filter)));
            }).collect(Collectors.toList()));
            filterGroups.add(groupedFilter);
        });
        return filterGroups.size() > 1 ? Filters.or(filterGroups) : Filters.and(filterGroups);
    }

    private Iterable<Document> retrieveData(MongoCollection<Document> collection, Bson filter, Bson projection, Bson sort, Integer limit) {
        if (this.step.getGroup() != null) {
            List<Bson> groupPipeline = this.buildGroupPipeline(this.step, filter);
            return collection.aggregate(groupPipeline).allowDiskUse(Boolean.valueOf(true));
        }
        FindIterable findResults = collection.find(filter).projection(projection).sort(sort).allowDiskUse(Boolean.valueOf(true)).noCursorTimeout(true);
        if (limit > 0) {
            findResults.limit(limit.intValue());
        }
        return findResults;
    }

    public void saveRecord(FlowStepData step, Map<String, Object> recordData, FlowStepContext stepContext, FlowPackageContext stepPackageContext) {
        MongoStep mongoStep = (MongoStep)step;
        RecordFieldExtractor recordFieldExtractor = new RecordFieldExtractor();
        ExtractedRecord extractedRecord = new ExtractedRecord();
        HashMap<String, Object> primaryKeyValue = new HashMap<String, Object>();
        step.getFields().forEach(field -> {
            Object value;
            if (mongoStep.getGroup() != null) {
                String fieldName = field.getId().equalsIgnoreCase(mongoStep.getGroup().getFieldName()) ? field.getId() : "_id." + field.getId();
                value = recordFieldExtractor.getValue(recordData, fieldName);
            } else {
                value = recordFieldExtractor.getValue(recordData, field.getId());
            }
            value = field.getValue(value, stepContext);
            extractedRecord.put((Object)field.getName(), value);
            if (field.isPrimaryKey()) {
                primaryKeyValue.put(field.getName(), value);
            }
        });
        if (stepPackageContext.getStepDependencies().contains(step.getId()) || !step.isIgnoreIfNeverUsed()) {
            stepPackageContext.addRecordInCache((FlowStep)step, extractedRecord);
        }
        if (step.hasPrimaryKey()) {
            primaryKeyValue.forEach((key, value) -> stepPackageContext.addRecordInCache((FlowStep)step, key, value));
        }
    }
}

