/*
 * Decompiled with CFR 0.152.
 */
package org.flowstep.mongo;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import org.flowstep.core.connection.ConnectionBuilder;
import org.flowstep.core.connection.EnvironmentConnection;
import org.flowstep.core.model.environment.EnvironmentItemSettings;
import org.flowstep.mongo.model.MongoEnvironment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class MongoConnectionBuilder
implements ConnectionBuilder {
    public boolean canBuildConnection(EnvironmentItemSettings settings) {
        return settings instanceof MongoEnvironment;
    }

    public EnvironmentConnection buildConnection(EnvironmentItemSettings settings) {
        return new EnvironmentConnection((Object)this.mongoTemplate((MongoEnvironment)settings), settings);
    }

    private MongoClient mongoClient(MongoEnvironment settings) {
        return MongoClients.create((String)settings.getUri());
    }

    public MongoTemplate mongoTemplate(MongoEnvironment settings) {
        return new MongoTemplate(this.mongoClient(settings), settings.getDatabase());
    }
}

