package org.flowstep.mongo.transform;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.flowstep.core.FlowComponent;
import org.flowstep.core.context.FlowStepContext;
import org.flowstep.core.model.step.FlowStepComponent;
import org.flowstep.core.transform.FlowTransform;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;

@FlowComponent
public class DateFormat implements FlowTransform, FlowStepComponent {
    private String format = "yyyy-MM-dd HH:mm:ss.SSS'Z'";
    private String timeZone;
    @JsonIgnore
    private SimpleDateFormat simpleDateFormat;
    @JsonIgnore
    private DateTimeFormatter dateTimeFormatter;

    public String getFormat() {
        return format;
    }

    public DateFormat setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getTimeZone() {
        return timeZone;
    }

    public DateFormat setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Override
    public void postConfigure() {
        simpleDateFormat = new SimpleDateFormat(format);
        dateTimeFormatter = DateTimeFormatter.ofPattern(format);
    }

    @Override
    public Object transform(Object value, FlowStepContext context) {
        if (value instanceof Date) {
            if (timeZone != null)
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
            return simpleDateFormat.format(value);
        } else if (value instanceof LocalDateTime) {
            if (timeZone != null)
                dateTimeFormatter = dateTimeFormatter.withZone(ZoneId.of(timeZone));
            return ((LocalDateTime) value).format(dateTimeFormatter);
        } else
            return value;
    }
}


