package org.flowstep.mongo.model.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.flowstep.mongo.model.StepSortType;

import java.io.IOException;

public class StepSortTypeSerializer extends JsonSerializer<StepSortType> {

    @Override
    public void serialize(StepSortType stepSortType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeString(stepSortType.toString().toLowerCase());
    }
}
