package org.flowstep.mongo.model.serialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import org.flowstep.mongo.model.StepSortType;

import java.io.IOException;

public class StepSortTypeDeserializer extends JsonDeserializer<StepSortType> {

    public StepSortType deserialize(JsonParser parser, DeserializationContext context)
            throws IOException {
        return StepSortType.valueOf(parser.getText().toUpperCase());
    }
}
