package org.flowstep.mongo.model;

import com.mongodb.client.model.Sorts;
import org.bson.conversions.Bson;

import java.util.function.Function;

public enum StepSortType {
    ASC(Sorts::ascending),
    DESC(Sorts::descending);

    private final Function<String, Bson> function;

    StepSortType(Function<String, Bson> function) {
        this.function = function;
    }

    public Bson getSort(String fieldName) {
        return function.apply(fieldName);
    }
}
