package org.flowstep.mongo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.bson.conversions.Bson;
import org.flowstep.mongo.model.serialize.StepSortTypeDeserializer;
import org.flowstep.mongo.model.serialize.StepSortTypeSerializer;

public class StepSort {
    private String fieldName;
    @JsonSerialize(using = StepSortTypeSerializer.class)
    @JsonDeserialize(using = StepSortTypeDeserializer.class)
    private StepSortType sorting;

    public StepSort() {
    }

    public StepSort(StepSort stepSort) {
        fieldName = stepSort.fieldName;
        sorting = stepSort.sorting;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public StepSortType getSorting() {
        return sorting;
    }

    public void setSorting(StepSortType sorting) {
        this.sorting = sorting;
    }

    @JsonIgnore
    public Bson getSort() {
        return sorting.getSort(fieldName);
    }

    @JsonIgnore
    public Bson getSort(String prefix) {
        return sorting.getSort(prefix + fieldName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        StepSort stepSort = (StepSort) o;

        return new EqualsBuilder().append(fieldName, stepSort.fieldName).append(sorting, stepSort.sorting).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(fieldName).append(sorting).toHashCode();
    }
}
