package org.flowstep.mongo.model;

import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.BsonField;

import java.util.function.Function;

public enum StepGroupType {
    AVG(fieldName -> Accumulators.avg(fieldName, 1)),
    FIRST(fieldName -> Accumulators.first(fieldName, 1)),
    LAST(fieldName -> Accumulators.last(fieldName, 1)),
    MAX(fieldName -> Accumulators.max(fieldName, 1)),
    MIN(fieldName -> Accumulators.min(fieldName, 1)),
    SUM(fieldName -> Accumulators.sum(fieldName, 1));

    private Function<String, BsonField> function;

    StepGroupType(Function<String, BsonField> function) {
        this.function = function;
    }

    public BsonField getGroupOperator(String fieldName) {
        return function.apply(fieldName);
    }

}
