package org.flowstep.mongo.model;

import com.mongodb.client.model.Filters;
import org.bson.conversions.Bson;

import java.util.function.Function;

public enum StepFilterOperator {
    AND(Filters::and),
    OR(Filters::or),
    NOR(Filters::nor);

    private final Function<Iterable<Bson>, Bson> function;

    StepFilterOperator(Function<Iterable<Bson>, Bson> function) {
        this.function = function;
    }

    public Function<Iterable<Bson>, Bson> getOperatorFunction() {
        return function;
    }
}
