package org.flowstep.mongo.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.flowstep.core.model.StepFilter;
import org.flowstep.mongo.model.serialize.FilterConditionDeserializer;
import org.flowstep.mongo.model.serialize.FilterConditionSerializer;

public class MongoStepFilter extends StepFilter {
    @JsonDeserialize(using = FilterConditionDeserializer.class)
    @JsonSerialize(using = FilterConditionSerializer.class)
    private FilterCondition condition;

    public MongoStepFilter() {
        super();
    }

    public MongoStepFilter(MongoStepFilter filter) {
        super(filter);
        this.condition = filter.condition;
    }

    public FilterCondition getCondition() {
        return condition;
    }

    public MongoStepFilter setCondition(FilterCondition condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        MongoStepFilter that = (MongoStepFilter) o;

        return new EqualsBuilder().appendSuper(super.equals(o)).append(condition, that.condition).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(condition).toHashCode();
    }
}
