package org.flowstep.mongo.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.flowstep.core.model.environment.EnvironmentItemSettings;
import org.flowstep.core.model.step.FlowStepComponent;
import org.springframework.stereotype.Component;

@Component
public class MongoEnvironment extends EnvironmentItemSettings implements FlowStepComponent {
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("database")
    private String database;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("collection")
    private String collection;

    public MongoEnvironment() {
        super();
    }

    public MongoEnvironment(MongoEnvironment environment) {
        super(environment);
        database = environment.database;
        collection = environment.collection;
    }

    public String getDatabase() {
        return database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getCollection() {
        return collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        MongoEnvironment that = (MongoEnvironment) o;

        return new EqualsBuilder().appendSuper(super.equals(o)).append(database, that.database).append(collection, that.collection).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(database).append(collection).toHashCode();
    }
}
