package org.flowstep.mongo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.mongodb.client.model.BsonField;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.flowstep.mongo.model.serialize.StepGroupTypeDeserializer;
import org.flowstep.mongo.model.serialize.StepGroupTypeSerializer;

public class Group {
    private String fieldName;

    @JsonSerialize(using = StepGroupTypeSerializer.class)
    @JsonDeserialize(using = StepGroupTypeDeserializer.class)
    private StepGroupType type;

    public Group() {
    }

    public Group(Group group) {
        fieldName = group.fieldName;
        type = group.type;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public StepGroupType getType() {
        return type;
    }

    public void setType(StepGroupType type) {
        this.type = type;
    }

    @JsonIgnore
    public BsonField getGroupOperator() {
        return type.getGroupOperator(fieldName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        Group group = (Group) o;

        return new EqualsBuilder().append(fieldName, group.fieldName).append(type, group.type).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(fieldName).append(type).toHashCode();
    }
}
