package org.flowstep.mongo;

import org.flowstep.core.connection.EnvironmentConnection;
import org.flowstep.core.context.FlowPackageContext;
import org.flowstep.core.factory.FlowEnvironmentFactory;
import org.flowstep.core.model.step.FlowGroup;
import org.flowstep.core.model.step.FlowStep;
import org.flowstep.core.processor.FlowProcessor;
import org.flowstep.core.processor.FlowProcessorType;
import org.flowstep.mongo.model.MongoStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MongoStepProcessor implements FlowProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MongoStepProcessor.class);

    @Autowired
    private FlowEnvironmentFactory environmentFactory;

    @Override
    public FlowProcessorType getType() {
        return FlowProcessorType.PROCESSOR;
    }

    @Override
    public boolean canProcess(FlowStep step) {
        return step instanceof MongoStep;
    }

    @Override
    public boolean process(FlowGroup stepGroup, FlowStep step, FlowPackageContext stepPackageContext) {
        MongoStep mongoStep = (MongoStep) step;
        EnvironmentConnection connection = environmentFactory.getEnvironmentConnection(mongoStep.getEnvironment(),
                stepPackageContext.getStepPackage());

        if (connection != null) {
            new MongoDataProvider()
                    .setStepGroup(stepGroup)
                    .setStep(mongoStep)
                    .setConnection(connection)
                    .setStepPackageContext(stepPackageContext)
                    .build();

        } else
            logger.error("Error: couldn't find connection for environment: {}", mongoStep.getEnvironment());

        return true;
    }
}
