package org.flowstep.mongo;

import org.apache.commons.lang3.StringUtils;
import org.flowstep.core.FilterDependencyLink;
import org.flowstep.core.context.FlowPackageContext;
import org.flowstep.core.model.step.FlowGroup;
import org.flowstep.core.model.step.FlowStep;
import org.flowstep.core.model.step.FlowStepData;
import org.flowstep.core.processor.FlowProcessor;
import org.flowstep.core.processor.FlowProcessorType;
import org.flowstep.mongo.model.HasStepFilters;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class FilterDependenciesPreProcessor implements FlowProcessor {

    @Override
    public FlowProcessorType getType() {
        return FlowProcessorType.PREPROCESSOR;
    }

    @Override
    public boolean canProcess(FlowStep step) {
        return step instanceof FlowStepData;
    }

    @Override
    public boolean process(FlowGroup stepGroup, FlowStep step, FlowPackageContext stepPackageContext) {
        FlowStepData dataStep = (FlowStepData) step;

        if (dataStep instanceof HasStepFilters) {
            HasStepFilters filters = (HasStepFilters) dataStep;

            filters.getAllFilters()
                    .filter(filter -> StringUtils.isNotBlank(filter.getStep()))
                    .forEach(filter -> {
                        FilterDependencyLink link = new FilterDependencyLink(filter.getStep());

                        if (link.isCorrect()) {
                            List<Object> cashedSet = new ArrayList<>(stepPackageContext.getCachedSet(link));
                            filter.setFieldValue(cashedSet);
                        }
                    });
        }

        return true;
    }
}
