/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.cmd;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntity;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntityManager;

public class ReleaseLockCmd
implements Command<Void> {
    protected String lockName;
    protected String engineType;
    protected boolean delete;

    public ReleaseLockCmd(String lockName, String engineType, boolean delete) {
        this.lockName = lockName;
        this.engineType = engineType;
        this.delete = delete;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        PropertyEntityManager propertyEntityManager = commandContext.getEngineConfigurations().get(this.engineType).getPropertyEntityManager();
        PropertyEntity property = (PropertyEntity)propertyEntityManager.findById(this.lockName);
        if (property != null) {
            property.setValue(null);
            if (this.delete) {
                propertyEntityManager.delete(property);
            }
            return null;
        }
        throw new FlowableObjectNotFoundException("Lock with name " + this.lockName + " does not exist");
    }
}

