/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.util;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.flowable.common.engine.api.FlowableClassLoadingException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectUtil.class);
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is)[A-Z].*");
    private static final Pattern SETTER_PATTERN = Pattern.compile("set[A-Z].*");

    public static ClassLoader getClassLoader() {
        ClassLoader loader = ReflectUtil.getCustomClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    public static Class<?> loadClass(String className) {
        Throwable throwable;
        Class clazz;
        block11: {
            clazz = null;
            ClassLoader classLoader = ReflectUtil.getCustomClassLoader();
            throwable = null;
            if (classLoader != null) {
                try {
                    LOGGER.trace("Trying to load class with custom classloader: {}", (Object)className);
                    clazz = ReflectUtil.loadClass(classLoader, className);
                }
                catch (Throwable t) {
                    throwable = t;
                }
            }
            if (clazz == null) {
                block10: {
                    try {
                        LOGGER.trace("Trying to load class with current thread context classloader: {}", (Object)className);
                        clazz = ReflectUtil.loadClass(Thread.currentThread().getContextClassLoader(), className);
                    }
                    catch (Throwable t) {
                        if (throwable != null) break block10;
                        throwable = t;
                    }
                }
                if (clazz == null) {
                    try {
                        LOGGER.trace("Trying to load class with local classloader: {}", (Object)className);
                        clazz = ReflectUtil.loadClass(ReflectUtil.class.getClassLoader(), className);
                    }
                    catch (Throwable t) {
                        if (throwable != null) break block11;
                        throwable = t;
                    }
                }
            }
        }
        if (clazz == null) {
            throw new FlowableClassLoadingException(className, throwable);
        }
        return clazz;
    }

    public static InputStream getResourceAsStream(String name) {
        InputStream resourceStream = null;
        ClassLoader classLoader = ReflectUtil.getCustomClassLoader();
        if (classLoader != null) {
            resourceStream = classLoader.getResourceAsStream(name);
        }
        if (resourceStream == null && (resourceStream = (classLoader = Thread.currentThread().getContextClassLoader()).getResourceAsStream(name)) == null) {
            classLoader = ReflectUtil.class.getClassLoader();
            resourceStream = classLoader.getResourceAsStream(name);
        }
        return resourceStream;
    }

    public static URL getResource(String name) {
        URL url = null;
        ClassLoader classLoader = ReflectUtil.getCustomClassLoader();
        if (classLoader != null) {
            url = classLoader.getResource(name);
        }
        if (url == null && (url = (classLoader = Thread.currentThread().getContextClassLoader()).getResource(name)) == null) {
            classLoader = ReflectUtil.class.getClassLoader();
            url = classLoader.getResource(name);
        }
        return url;
    }

    public static Object instantiate(String className) {
        try {
            Class<?> clazz = ReflectUtil.loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new FlowableException("couldn't instantiate class " + className, (Throwable)e);
        }
    }

    public static Object invoke(Object target, String methodName, Object[] args) {
        try {
            Class<?> clazz = target.getClass();
            Method method = ReflectUtil.findMethod(clazz, methodName, args);
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't invoke " + methodName + " on " + target, (Throwable)e);
        }
    }

    public static void invokeSetterOrField(Object target, String name, Object value, boolean throwExceptionOnMissingField) {
        Method setterMethod = ReflectUtil.getSetter(name, target.getClass(), value.getClass());
        if (setterMethod != null) {
            ReflectUtil.invokeSetter(setterMethod, target, name, value);
        } else {
            Field field = ReflectUtil.getField(name, target);
            if (field == null) {
                if (throwExceptionOnMissingField) {
                    throw new FlowableIllegalArgumentException("Field definition uses non-existent field '" + name + "' of class " + target.getClass().getName());
                }
                return;
            }
            if (!ReflectUtil.fieldTypeCompatible(value, field)) {
                throw new FlowableIllegalArgumentException("Incompatible type set on field declaration '" + name + "' for class " + target.getClass().getName() + ". Declared value has type " + value.getClass().getName() + ", while expecting " + field.getType().getName());
            }
            ReflectUtil.setField(field, target, value);
        }
    }

    public static Field getField(String fieldName, Object object) {
        return ReflectUtil.getField(fieldName, object.getClass());
    }

    public static Field getField(String fieldName, Class<?> clazz) {
        Field field;
        block3: {
            field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (SecurityException e) {
                throw new FlowableException("not allowed to access field " + field + " on class " + clazz.getCanonicalName(), (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                Class<?> superClass = clazz.getSuperclass();
                if (superClass == null) break block3;
                return ReflectUtil.getField(fieldName, superClass);
            }
        }
        return field;
    }

    public static void setField(Field field, Object object, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new FlowableException("Could not set field " + field, (Throwable)e);
        }
    }

    public static Method getSetter(String fieldName, Class<?> clazz, Class<?> fieldType) {
        String setterName = "set" + Character.toTitleCase(fieldName.charAt(0)) + fieldName.substring(1);
        try {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                Class<?>[] paramTypes;
                if (!method.getName().equals(setterName) || (paramTypes = method.getParameterTypes()) == null || paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(fieldType)) continue;
                return method;
            }
            return null;
        }
        catch (SecurityException e) {
            throw new FlowableException("Not allowed to access method " + setterName + " on class " + clazz.getCanonicalName(), (Throwable)e);
        }
    }

    public static void invokeSetter(Method setterMethod, Object target, String name, Object value) {
        try {
            setterMethod.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new FlowableException("Error while invoking '" + name + "' on class " + target.getClass().getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FlowableException("Illegal access when calling '" + name + "' on class " + target.getClass().getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new FlowableException("Exception while invoking '" + name + "' on class " + target.getClass().getName(), (Throwable)e);
        }
    }

    private static Method findMethod(Class<? extends Object> clazz, String methodName, Object[] args) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !ReflectUtil.matches(method.getParameterTypes(), args)) continue;
            return method;
        }
        Class<? extends Object> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return ReflectUtil.findMethod(superClass, methodName, args);
        }
        return null;
    }

    public static Object instantiate(String className, Object[] args) {
        Class<?> clazz = ReflectUtil.loadClass(className);
        Constructor<?> constructor = ReflectUtil.findMatchingConstructor(clazz, args);
        if (constructor == null) {
            throw new FlowableException("couldn't find constructor for " + className + " with args " + Arrays.asList(args));
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't find constructor for " + className + " with args " + Arrays.asList(args), (Throwable)e);
        }
    }

    protected static <T> Constructor<T> findMatchingConstructor(Class<T> clazz, Object[] args) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!ReflectUtil.matches(constructor.getParameterTypes(), args)) continue;
            return constructor;
        }
        return null;
    }

    protected static boolean matches(Class<?>[] parameterTypes, Object[] args) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return args == null || args.length == 0;
        }
        if (args == null || parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (args[i] == null || parameterTypes[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    protected static boolean fieldTypeCompatible(Object value, Field field) {
        if (value != null) {
            return field.getType().isAssignableFrom(value.getClass());
        }
        return true;
    }

    protected static ClassLoader getCustomClassLoader() {
        ClassLoader classLoader;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null && (classLoader = commandContext.getClassLoader()) != null) {
            return classLoader;
        }
        return null;
    }

    protected static Class loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        CommandContext commandContext = Context.getCommandContext();
        boolean useClassForName = commandContext == null || commandContext.isUseClassForNameClassLoading();
        return useClassForName ? Class.forName(className, true, classLoader) : classLoader.loadClass(className);
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        if (!GETTER_PATTERN.matcher(name).matches()) {
            return false;
        }
        if (name.startsWith("is")) {
            return params.length == 0 && "boolean".equalsIgnoreCase(type.getSimpleName());
        }
        return params.length == 0 && !type.equals(Void.TYPE);
    }

    public static boolean isSetter(Method method, boolean allowBuilderPattern) {
        String name = method.getName();
        Class<?> type = method.getReturnType();
        Class<?>[] params = method.getParameterTypes();
        if (!SETTER_PATTERN.matcher(name).matches()) {
            return false;
        }
        return params.length == 1 && (type.equals(Void.TYPE) || allowBuilderPattern && method.getDeclaringClass().isAssignableFrom(type));
    }

    public static boolean isSetter(Method method) {
        return ReflectUtil.isSetter(method, false);
    }

    public static String getGetterShorthandName(Method method) {
        if (!ReflectUtil.isGetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    public static String getSetterShorthandName(Method method) {
        if (!ReflectUtil.isSetter(method)) {
            return method.getName();
        }
        String name = method.getName();
        if (name.startsWith("set")) {
            name = name.substring(3);
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }
}

