/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.agenda;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.agenda.Agenda;
import org.flowable.common.engine.impl.agenda.ExecuteFutureActionOperation;

public class WaitForAnyFutureToFinishOperation
implements Runnable {
    protected final Agenda agenda;
    protected final List<ExecuteFutureActionOperation<?>> futureOperations;

    public WaitForAnyFutureToFinishOperation(Agenda agenda, List<ExecuteFutureActionOperation<?>> futureOperations) {
        this.agenda = agenda;
        this.futureOperations = futureOperations;
    }

    @Override
    public void run() {
        CompletableFuture[] anyOfFutures = new CompletableFuture[this.futureOperations.size()];
        for (int i = 0; i < this.futureOperations.size(); ++i) {
            anyOfFutures[i] = this.futureOperations.get(i).getFuture();
        }
        try {
            CompletableFuture.anyOf(anyOfFutures).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FlowableException("Future was interrupted", (Throwable)e);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        for (ExecuteFutureActionOperation<?> futureOperation : this.futureOperations) {
            if (futureOperation.isDone()) {
                this.agenda.planOperation(futureOperation);
                continue;
            }
            this.agenda.planFutureOperation(futureOperation.getFuture(), futureOperation.getAction());
        }
    }
}

