/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.persistence.deploy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeploymentCache<T>
implements DeploymentCache<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDeploymentCache.class);
    protected Map<String, T> cache;

    public DefaultDeploymentCache() {
        this.cache = Collections.synchronizedMap(new HashMap());
    }

    public DefaultDeploymentCache(final int limit) {
        this.cache = Collections.synchronizedMap(new LinkedHashMap<String, T>(limit + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
                boolean removeEldest;
                boolean bl = removeEldest = this.size() > limit;
                if (removeEldest && LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Cache limit is reached, {} will be evicted", (Object)eldest.getKey());
                }
                return removeEldest;
            }
        });
    }

    @Override
    public T get(String id) {
        return this.cache.get(id);
    }

    @Override
    public void add(String id, T obj) {
        this.cache.put(id, obj);
    }

    @Override
    public void remove(String id) {
        this.cache.remove(id);
    }

    @Override
    public boolean contains(String id) {
        return this.cache.containsKey(id);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public Collection<T> getAll() {
        return this.cache.values();
    }

    public int size() {
        return this.cache.size();
    }
}

