/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.agenda;

import java.util.LinkedList;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.agenda.Agenda;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAgenda
implements Agenda {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAgenda.class);
    protected CommandContext commandContext;
    protected LinkedList<Runnable> operations = new LinkedList();

    public AbstractAgenda(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    @Override
    public Runnable getNextOperation() {
        this.assertOperationsNotEmpty();
        return this.operations.poll();
    }

    @Override
    public Runnable peekOperation() {
        this.assertOperationsNotEmpty();
        return this.operations.peek();
    }

    protected void assertOperationsNotEmpty() {
        if (this.operations.isEmpty()) {
            throw new FlowableException("Unable to peek empty agenda.");
        }
    }

    @Override
    public void planOperation(Runnable operation) {
        this.operations.add(operation);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Operation {} added to agenda", operation.getClass());
        }
    }

    public LinkedList<Runnable> getOperations() {
        return this.operations;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public void setCommandContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

