/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.interceptor;

import org.flowable.engine.common.impl.cfg.TransactionContext;
import org.flowable.engine.common.impl.cfg.TransactionContextFactory;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.TransactionCommandContextCloseListener;

public class TransactionContextInterceptor
extends AbstractCommandInterceptor {
    protected TransactionContextFactory transactionContextFactory;

    public TransactionContextInterceptor() {
    }

    public TransactionContextInterceptor(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        CommandContext commandContext = Context.getCommandContext();
        boolean isReused = commandContext.isReused();
        boolean isContextSet = false;
        try {
            if (this.transactionContextFactory != null && !isReused) {
                TransactionContext transactionContext = this.transactionContextFactory.openTransactionContext(commandContext);
                Context.setTransactionContext(transactionContext);
                isContextSet = true;
                commandContext.addCloseListener(new TransactionCommandContextCloseListener(transactionContext));
            }
            T t = this.next.execute(config, command);
            return t;
        }
        finally {
            if (this.transactionContextFactory != null && isContextSet && !isReused) {
                Context.removeTransactionContext();
            }
        }
    }

    public TransactionContextFactory getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public void setTransactionContextFactory(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
    }
}

