/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.interceptor;

import java.util.HashMap;
import java.util.Map;
import org.flowable.engine.common.AbstractEngineConfiguration;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContextInterceptor
extends AbstractCommandInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandContextInterceptor.class);
    protected CommandContextFactory commandContextFactory;
    protected String currentEngineConfigurationKey;
    protected Map<String, AbstractEngineConfiguration> engineConfigurations = new HashMap<String, AbstractEngineConfiguration>();

    public CommandContextInterceptor() {
    }

    public CommandContextInterceptor(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        CommandContext context = Context.getCommandContext();
        boolean contextReused = false;
        AbstractEngineConfiguration previousEngineConfiguration = null;
        if (!config.isContextReusePossible() || context == null || context.getException() != null) {
            context = this.commandContextFactory.createCommandContext(command);
            context.setEngineConfigurations(this.engineConfigurations);
        } else {
            LOGGER.debug("Valid context found. Reusing it for the current command '{}'", (Object)command.getClass().getCanonicalName());
            contextReused = true;
            context.setReused(true);
            previousEngineConfiguration = context.getCurrentEngineConfiguration();
        }
        try {
            context.setCurrentEngineConfiguration(this.engineConfigurations.get(this.currentEngineConfigurationKey));
            Context.setCommandContext(context);
            T t = this.next.execute(config, command);
            return t;
        }
        catch (Exception e) {
            context.exception(e);
        }
        finally {
            try {
                if (!contextReused) {
                    context.close();
                }
            }
            finally {
                Context.removeCommandContext();
                context.setCurrentEngineConfiguration(previousEngineConfiguration);
            }
        }
        return null;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public void setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    public String getCurrentEngineConfigurationKey() {
        return this.currentEngineConfigurationKey;
    }

    public void setCurrentEngineConfigurationKey(String currentEngineConfigurationKey) {
        this.currentEngineConfigurationKey = currentEngineConfigurationKey;
    }

    public Map<String, AbstractEngineConfiguration> getEngineConfigurations() {
        return this.engineConfigurations;
    }

    public void setEngineConfigurations(Map<String, AbstractEngineConfiguration> engineConfigurations) {
        this.engineConfigurations = engineConfigurations;
    }
}

