/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.db;

import java.sql.Connection;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableOptimisticLockingException;
import org.flowable.engine.common.impl.db.AbstractDbSqlSession;
import org.flowable.engine.common.impl.db.AbstractDbSqlSessionFactory;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNonCachingDbSqlSession
extends AbstractDbSqlSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNonCachingDbSqlSession.class);

    public AbstractNonCachingDbSqlSession(AbstractDbSqlSessionFactory dbSqlSessionFactory) {
        super(dbSqlSessionFactory);
    }

    public AbstractNonCachingDbSqlSession(AbstractDbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        super(dbSqlSessionFactory, connection, catalog, schema);
    }

    @Override
    public void insert(Entity entity) {
        if (entity.getId() == null) {
            String id = this.dbSqlSessionFactory.getIdGenerator().getNextId();
            entity.setId(id);
        }
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(entity);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new FlowableException("no insert statement for " + entity.getClass() + " in the ibatis mapping files");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("inserting: {}", (Object)entity);
        }
        this.sqlSession.insert(insertStatement, (Object)entity);
    }

    @Override
    public void update(Entity entity) {
        int updatedRecords;
        String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(entity);
        if ((updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement)) == null) {
            throw new FlowableException("no update statement for " + entity.getClass() + " in the ibatis mapping files");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("updating: {}", (Object)entity);
        }
        if ((updatedRecords = this.sqlSession.update(updateStatement, (Object)entity)) == 0) {
            throw new FlowableOptimisticLockingException(entity + " was updated by another transaction concurrently");
        }
    }

    @Override
    public int update(String statement, Object parameters) {
        String updateStatement = this.dbSqlSessionFactory.mapStatement(statement);
        return this.sqlSession.update(updateStatement, parameters);
    }

    @Override
    public void delete(String statement, Object parameter) {
        this.sqlSession.delete(statement, parameter);
    }

    @Override
    public void delete(Entity entity) {
        String deleteStatement = this.dbSqlSessionFactory.getDeleteStatement(entity.getClass());
        if ((deleteStatement = this.dbSqlSessionFactory.mapStatement(deleteStatement)) == null) {
            throw new FlowableException("no delete statement for " + entity.getClass() + " in the ibatis mapping files");
        }
        this.sqlSession.delete(deleteStatement, (Object)entity);
    }
}

