/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.db;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.cfg.IdGenerator;
import org.flowable.engine.common.impl.db.AbstractDbSqlSession;
import org.flowable.engine.common.impl.interceptor.AbstractCommandContext;
import org.flowable.engine.common.impl.interceptor.Session;
import org.flowable.engine.common.impl.interceptor.SessionFactory;
import org.flowable.engine.common.impl.persistence.entity.Entity;

public abstract class AbstractDbSqlSessionFactory
implements SessionFactory {
    protected Map<String, Map<String, String>> databaseSpecificStatements = new HashMap<String, Map<String, String>>();
    protected String databaseType;
    protected String databaseTablePrefix = "";
    protected boolean tablePrefixIsSchema;
    protected String databaseCatalog;
    protected String databaseSchema;
    protected SqlSessionFactory sqlSessionFactory;
    protected IdGenerator idGenerator;
    protected Map<String, String> statementMappings;
    protected Map<Class<?>, String> insertStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> updateStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> deleteStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> selectStatements = new ConcurrentHashMap();
    protected boolean isDbHistoryUsed = true;

    @Override
    public Session openSession(AbstractCommandContext commandContext) {
        AbstractDbSqlSession dbSqlSession = this.createDbSqlSession();
        if (this.getDatabaseSchema() != null && this.getDatabaseSchema().length() > 0) {
            try {
                dbSqlSession.getSqlSession().getConnection().setSchema(this.getDatabaseSchema());
            }
            catch (SQLException e) {
                throw new FlowableException("Could not set database schema on connection", (Throwable)e);
            }
        }
        if (this.getDatabaseCatalog() != null && this.getDatabaseCatalog().length() > 0) {
            try {
                dbSqlSession.getSqlSession().getConnection().setCatalog(this.getDatabaseCatalog());
            }
            catch (SQLException e) {
                throw new FlowableException("Could not set database catalog on connection", (Throwable)e);
            }
        }
        if (dbSqlSession.getSqlSession().getConnection() == null) {
            throw new FlowableException("Invalid dbSqlSession: no active connection found");
        }
        return dbSqlSession;
    }

    protected abstract AbstractDbSqlSession createDbSqlSession();

    public String getInsertStatement(Entity object) {
        return this.getStatement(object.getClass(), this.insertStatements, "insert");
    }

    public String getInsertStatement(Class<? extends Entity> clazz) {
        return this.getStatement(clazz, this.insertStatements, "insert");
    }

    public String getUpdateStatement(Entity object) {
        return this.getStatement(object.getClass(), this.updateStatements, "update");
    }

    public String getDeleteStatement(Class<?> entityClass) {
        return this.getStatement(entityClass, this.deleteStatements, "delete");
    }

    public String getSelectStatement(Class<?> entityClass) {
        return this.getStatement(entityClass, this.selectStatements, "select");
    }

    protected String getStatement(Class<?> entityClass, Map<Class<?>, String> cachedStatements, String prefix) {
        String statement = cachedStatements.get(entityClass);
        if (statement != null) {
            return statement;
        }
        statement = prefix + entityClass.getSimpleName();
        statement = statement.endsWith("Impl") ? statement.substring(0, statement.length() - 10) : statement.substring(0, statement.length() - 6);
        cachedStatements.put(entityClass, statement);
        return statement;
    }

    protected void addDatabaseSpecificStatement(String databaseType, String activitiStatement, String ibatisStatement) {
        Map<String, String> specificStatements = this.databaseSpecificStatements.get(databaseType);
        if (specificStatements == null) {
            specificStatements = new HashMap<String, String>();
            this.databaseSpecificStatements.put(databaseType, specificStatements);
        }
        specificStatements.put(activitiStatement, ibatisStatement);
    }

    public String mapStatement(String statement) {
        if (this.statementMappings == null) {
            return statement;
        }
        String mappedStatement = this.statementMappings.get(statement);
        return mappedStatement != null ? mappedStatement : statement;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        this.statementMappings = this.databaseSpecificStatements.get(databaseType);
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, Map<String, String>> getDatabaseSpecificStatements() {
        return this.databaseSpecificStatements;
    }

    public void setDatabaseSpecificStatements(Map<String, Map<String, String>> databaseSpecificStatements) {
        this.databaseSpecificStatements = databaseSpecificStatements;
    }

    public Map<String, String> getStatementMappings() {
        return this.statementMappings;
    }

    public void setStatementMappings(Map<String, String> statementMappings) {
        this.statementMappings = statementMappings;
    }

    public Map<Class<?>, String> getInsertStatements() {
        return this.insertStatements;
    }

    public void setInsertStatements(Map<Class<?>, String> insertStatements) {
        this.insertStatements = insertStatements;
    }

    public Map<Class<?>, String> getUpdateStatements() {
        return this.updateStatements;
    }

    public void setUpdateStatements(Map<Class<?>, String> updateStatements) {
        this.updateStatements = updateStatements;
    }

    public Map<Class<?>, String> getDeleteStatements() {
        return this.deleteStatements;
    }

    public void setDeleteStatements(Map<Class<?>, String> deleteStatements) {
        this.deleteStatements = deleteStatements;
    }

    public Map<Class<?>, String> getSelectStatements() {
        return this.selectStatements;
    }

    public void setSelectStatements(Map<Class<?>, String> selectStatements) {
        this.selectStatements = selectStatements;
    }

    public boolean isDbHistoryUsed() {
        return this.isDbHistoryUsed;
    }

    public void setDbHistoryUsed(boolean isDbHistoryUsed) {
        this.isDbHistoryUsed = isDbHistoryUsed;
    }

    public void setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public String getDatabaseCatalog() {
        return this.databaseCatalog;
    }

    public void setDatabaseCatalog(String databaseCatalog) {
        this.databaseCatalog = databaseCatalog;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public void setTablePrefixIsSchema(boolean tablePrefixIsSchema) {
        this.tablePrefixIsSchema = tablePrefixIsSchema;
    }

    public boolean isTablePrefixIsSchema() {
        return this.tablePrefixIsSchema;
    }
}

