/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.db;

import java.sql.Connection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.ibatis.session.SqlSession;
import org.flowable.engine.common.impl.Page;
import org.flowable.engine.common.impl.db.AbstractDbSqlSessionFactory;
import org.flowable.engine.common.impl.db.ListQueryParameterObject;
import org.flowable.engine.common.impl.interceptor.Session;
import org.flowable.engine.common.impl.persistence.entity.Entity;

public abstract class AbstractDbSqlSession
implements Session {
    protected static final Pattern CLEAN_VERSION_REGEX = Pattern.compile("\\d\\.\\d*");
    public static String[] JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};
    protected SqlSession sqlSession;
    protected AbstractDbSqlSessionFactory dbSqlSessionFactory;
    protected String connectionMetadataDefaultCatalog;
    protected String connectionMetadataDefaultSchema;

    public AbstractDbSqlSession(AbstractDbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
    }

    public AbstractDbSqlSession(AbstractDbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    public List selectList(String statement) {
        return this.selectList(statement, null, -1, -1);
    }

    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, -1, -1);
    }

    public List selectList(String statement, Object parameter, Page page) {
        if (page != null) {
            return this.selectList(statement, parameter, page.getFirstResult(), page.getMaxResults());
        }
        return this.selectList(statement, parameter, -1, -1);
    }

    public List selectList(String statement, ListQueryParameterObject parameter) {
        parameter.setDatabaseType(this.dbSqlSessionFactory.getDatabaseType());
        return this.selectListWithRawParameter(statement, parameter);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectList(statement, new ListQueryParameterObject(parameter, firstResult, maxResults));
    }

    public List selectListWithRawParameter(String statement, Object parameter) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        return this.sqlSession.selectList(statement, parameter);
    }

    public Object selectOne(String statement, Object parameter) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        Object result = this.sqlSession.selectOne(statement, parameter);
        return result;
    }

    public <T extends Entity> T selectById(Class<T> entityClass, String id) {
        Entity entity = null;
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(entityClass);
        entity = (Entity)this.sqlSession.selectOne(selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement), (Object)id);
        if (entity == null) {
            return null;
        }
        return (T)entity;
    }

    public abstract void insert(Entity var1);

    public abstract void update(Entity var1);

    public abstract int update(String var1, Object var2);

    public abstract void delete(String var1, Object var2);

    public abstract void delete(Entity var1);

    public void dbSchemaCheckVersion() {
    }

    public void dbSchemaCreate() {
    }

    public void dbSchemaDrop() {
    }

    @Override
    public void flush() {
        this.sqlSession.flushStatements();
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    public void commit() {
        this.sqlSession.commit();
    }

    public void rollback() {
        this.sqlSession.rollback();
    }

    public <T> T getCustomMapper(Class<T> type) {
        return (T)this.sqlSession.getMapper(type);
    }

    public boolean isMysql() {
        return this.dbSqlSessionFactory.getDatabaseType().equals("mysql");
    }

    public boolean isOracle() {
        return this.dbSqlSessionFactory.getDatabaseType().equals("oracle");
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public AbstractDbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }
}

