/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.typeinfo;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flinkx.api.typeinfo.CaseClassComparator;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

@Public
public abstract class CaseClassTypeInfo<T extends Product>
extends TupleTypeInfoBase<T> {
    private final Class<T> clazz;
    private final TypeInformation[] typeParamTypeInfos;
    private final Seq<TypeInformation<?>> fieldTypes;
    private final Seq fieldNames;
    private final Pattern PATTERN_NESTED_FIELDS;
    private final Pattern PATTERN_NESTED_FIELDS_WILDCARD;
    private final Pattern PATTERN_INT_FIELD;

    public CaseClassTypeInfo(Class<T> clazz, TypeInformation<?>[] typeParamTypeInfos, Seq<TypeInformation<?>> fieldTypes, Seq<String> fieldNames) {
        this.clazz = clazz;
        this.typeParamTypeInfos = typeParamTypeInfos;
        this.fieldTypes = fieldTypes;
        this.fieldNames = fieldNames;
        super(clazz, (TypeInformation[])Arrays$.MODULE$.seqToArray(fieldTypes, TypeInformation.class));
        String REGEX_INT_FIELD = "[0-9]+";
        String REGEX_STR_FIELD = "[\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*";
        String REGEX_FIELD = new StringBuilder(1).append(REGEX_STR_FIELD).append("|").append(REGEX_INT_FIELD).toString();
        String REGEX_NESTED_FIELDS = new StringBuilder(11).append("(").append(REGEX_FIELD).append(")(\\.(.+))?").toString();
        String REGEX_NESTED_FIELDS_WILDCARD = new StringBuilder(6).append(REGEX_NESTED_FIELDS).append("|\\").append("*").append("|\\").append("_").toString();
        this.PATTERN_NESTED_FIELDS = Pattern.compile(REGEX_NESTED_FIELDS);
        this.PATTERN_NESTED_FIELDS_WILDCARD = Pattern.compile(REGEX_NESTED_FIELDS_WILDCARD);
        this.PATTERN_INT_FIELD = Pattern.compile(REGEX_INT_FIELD);
    }

    public TypeInformation<?>[] typeParamTypeInfos() {
        return this.typeParamTypeInfos;
    }

    public Seq<String> fieldNames() {
        return this.fieldNames;
    }

    @PublicEvolving
    public java.util.Map<String, TypeInformation<?>> getGenericParameters() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.typeParamTypeInfos());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TypeInformation info = (TypeInformation)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(1).append("T").append(index + 1).toString());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)info);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    @PublicEvolving
    public int[] getFieldIndices(String[] fields) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])fields);
        return (int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x -> this.fieldNames().indexOf(x), ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    @PublicEvolving
    public void getFlatFields(String fieldExpression, int offset, List<CompositeType.FlatFieldDescriptor> result) {
        String tail;
        ObjectRef field;
        Matcher matcher;
        block7: {
            block6: {
                matcher = this.PATTERN_NESTED_FIELDS_WILDCARD.matcher(fieldExpression);
                if (!matcher.matches()) {
                    throw new CompositeType.InvalidFieldReferenceException(new StringBuilder(33).append("Invalid tuple field reference \"").append(fieldExpression).append("\".").toString());
                }
                field = ObjectRef.create((Object)matcher.group(0));
                String string = (String)field.elem;
                String string2 = "*";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block6;
                String string3 = (String)field.elem;
                String string4 = "_";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block7;
            }
            IntRef keyPosition = IntRef.create((int)0);
            this.fieldTypes.foreach((Function1)(JProcedure1 & Serializable)fType -> {
                int n;
                Boolean bl;
                TypeInformation typeInformation = fType;
                if (typeInformation instanceof CompositeType) {
                    int n2;
                    CompositeType ct = (CompositeType)typeInformation;
                    ct.getFlatFields("*", offset + keyPosition$1.elem, result);
                    keyPosition$1.elem = n2 = keyPosition$1.elem + (ct.getTotalFields() - 1);
                    bl = BoxedUnit.UNIT;
                } else {
                    bl = BoxesRunTime.boxToBoolean((boolean)result.add(new CompositeType.FlatFieldDescriptor(offset + keyPosition$1.elem, fType)));
                }
                keyPosition$1.elem = n = keyPosition$1.elem + 1;
            });
            return;
        }
        String string = matcher.group(1);
        field.elem = string;
        string = null;
        Matcher intFieldMatcher = this.PATTERN_INT_FIELD.matcher((String)field.elem);
        if (intFieldMatcher.matches()) {
            String string5 = new StringBuilder(1).append("_").append(Predef$.MODULE$.Integer2int(Integer.valueOf((String)field.elem)) + 1).toString();
            field.elem = string5;
            string5 = null;
        }
        if ((tail = matcher.group(3)) == null) {
            this.extractFlatFields$1(field, result, 0, offset);
            return;
        }
        this.extractFlatFields$2(field, tail, result, 0, offset);
    }

    @PublicEvolving
    public <X> TypeInformation<X> getTypeAt(String fieldExpression) {
        Matcher matcher;
        Object object;
        block6: {
            object = new Object();
            try {
                matcher = this.PATTERN_NESTED_FIELDS.matcher(fieldExpression);
                if (matcher.matches()) break block6;
                if (fieldExpression.startsWith("*") || fieldExpression.startsWith("_")) {
                    throw new CompositeType.InvalidFieldReferenceException("Wildcard expressions are not allowed here.");
                }
                throw new CompositeType.InvalidFieldReferenceException(new StringBuilder(49).append("Invalid format of case class field expression \"").append(fieldExpression).append("\".").toString());
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() != object) {
                    throw ex;
                }
                return (TypeInformation)ex.value();
            }
        }
        ObjectRef field = ObjectRef.create((Object)matcher.group(1));
        String tail = matcher.group(3);
        Matcher intFieldMatcher = this.PATTERN_INT_FIELD.matcher((String)field.elem);
        if (intFieldMatcher.matches()) {
            String string = new StringBuilder(1).append("_").append(Predef$.MODULE$.Integer2int(Integer.valueOf((String)field.elem)) + 1).toString();
            field.elem = string;
            string = null;
        }
        this.fieldNames().indices().foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Object object = this.fieldNames().apply(i);
            String string = (String)field$3.elem;
            if (!(object != null ? !object.equals(string) : string != null)) {
                if (tail == null) {
                    throw new NonLocalReturnControl(object, (Object)this.getTypeAt(i));
                }
                TypeInformation typeInformation = (TypeInformation)this.fieldTypes.apply(i);
                if (typeInformation instanceof CompositeType) {
                    CompositeType co = (CompositeType)typeInformation;
                    throw new NonLocalReturnControl(object, (Object)co.getTypeAt(tail));
                }
                throw new CompositeType.InvalidFieldReferenceException(new StringBuilder(56).append("Nested field expression \"").append(tail).append("\" not possible on atomic type ").append(this.fieldTypes.apply(i)).append(".").toString());
            }
        });
        throw new CompositeType.InvalidFieldReferenceException(new StringBuilder(33).append("Unable to find field \"").append((String)field.elem).append("\" in type ").append((Object)this).append(".").toString());
    }

    @PublicEvolving
    public String[] getFieldNames() {
        return (String[])this.fieldNames().toArray(ClassTag$.MODULE$.apply(String.class));
    }

    @PublicEvolving
    public int getFieldIndex(String fieldName) {
        int result = this.fieldNames().indexOf((Object)fieldName);
        if (result != this.fieldNames().lastIndexOf((Object)fieldName, this.fieldNames().lastIndexOf$default$2())) {
            return -1;
        }
        return result;
    }

    @PublicEvolving
    public CompositeType.TypeComparatorBuilder<T> createTypeComparatorBuilder() {
        return new CaseClassTypeComparatorBuilder();
    }

    public String toString() {
        return new StringBuilder(2).append(this.clazz.getName()).append("(").append(((IterableOnceOps)((IterableOps)this.fieldNames().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])this.types))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String n = (String)tuple2._1();
                TypeInformation t = (TypeInformation)tuple2._2();
                return new StringBuilder(2).append(n).append(": ").append(t).toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString(", ")).append(")").toString();
    }

    public boolean isCaseClass() {
        return true;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof CaseClassTypeInfo) {
            CaseClassTypeInfo caseClass = (CaseClassTypeInfo)((Object)object);
            return caseClass.canEqual((Object)this) && super.equals((Object)caseClass) && Predef$.MODULE$.wrapRefArray((Object[])this.typeParamTypeInfos()).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])caseClass.typeParamTypeInfos())) && this.fieldNames().equals(caseClass.fieldNames());
        }
        return false;
    }

    public int hashCode() {
        return 31 * (31 * super.hashCode() + this.fieldNames().hashCode()) + Arrays.hashCode(this.typeParamTypeInfos());
    }

    public boolean canEqual(Object obj) {
        return obj instanceof CaseClassTypeInfo;
    }

    public TypeInformation<?>[] protected$types() {
        return this.types;
    }

    private final void extractFlatFields$1(ObjectRef field$1, List result$2, int index, int pos) {
        while (true) {
            if (index >= this.fieldNames().size()) {
                throw new CompositeType.InvalidFieldReferenceException(new StringBuilder(33).append("Unable to find field \"").append((String)field$1.elem).append("\" in type ").append((Object)this).append(".").toString());
            }
            String string = (String)field$1.elem;
            Object object = this.fieldNames().apply(index);
            if (!(string != null ? !string.equals(object) : object != null)) {
                TypeInformation typeInformation = (TypeInformation)this.fieldTypes.apply(index);
                if (typeInformation instanceof CompositeType) {
                    CompositeType ct = (CompositeType)typeInformation;
                    ct.getFlatFields("*", pos, result$2);
                    return;
                }
                result$2.add(new CompositeType.FlatFieldDescriptor(pos, (TypeInformation)this.fieldTypes.apply(index)));
                return;
            }
            int n = index + 1;
            int n2 = pos + ((TypeInformation)this.fieldTypes.apply(index)).getTotalFields();
            index = n;
            pos = n2;
        }
    }

    private final void extractFlatFields$2(ObjectRef field$2, String tail$1, List result$3, int index, int pos) {
        while (true) {
            if (index >= this.fieldNames().size()) {
                throw new CompositeType.InvalidFieldReferenceException(new StringBuilder(33).append("Unable to find field \"").append((String)field$2.elem).append("\" in type ").append((Object)this).append(".").toString());
            }
            String string = (String)field$2.elem;
            Object object = this.fieldNames().apply(index);
            if (!(string != null ? !string.equals(object) : object != null)) {
                TypeInformation typeInformation = (TypeInformation)this.fieldTypes.apply(index);
                if (typeInformation instanceof CompositeType) {
                    CompositeType ct = (CompositeType)typeInformation;
                    ct.getFlatFields(tail$1, pos, result$3);
                    return;
                }
                throw new CompositeType.InvalidFieldReferenceException(new StringBuilder(56).append("Nested field expression \"").append(tail$1).append("\" not possible on atomic type ").append(this.fieldTypes.apply(index)).append(".").toString());
            }
            int n = index + 1;
            int n2 = pos + ((TypeInformation)this.fieldTypes.apply(index)).getTotalFields();
            index = n;
            pos = n2;
        }
    }

    public static final /* synthetic */ TypeSerializer org$apache$flinkx$api$typeinfo$CaseClassTypeInfo$CaseClassTypeComparatorBuilder$$_$createTypeComparator$$anonfun$1(ExecutionConfig config$1, TypeInformation _$1) {
        return _$1.createSerializer(config$1);
    }

    public class CaseClassTypeComparatorBuilder
    implements CompositeType.TypeComparatorBuilder<T> {
        private final ArrayBuffer fieldComparators;
        private final ArrayBuffer logicalKeyFields;

        public CaseClassTypeComparatorBuilder() {
            if (CaseClassTypeInfo.this == null) {
                throw new NullPointerException();
            }
            this.fieldComparators = new ArrayBuffer();
            this.logicalKeyFields = new ArrayBuffer();
        }

        public ArrayBuffer<TypeComparator<?>> fieldComparators() {
            return this.fieldComparators;
        }

        public ArrayBuffer<Object> logicalKeyFields() {
            return this.logicalKeyFields;
        }

        public void initializeTypeComparatorBuilder(int size) {
            this.fieldComparators().sizeHint(size);
            this.logicalKeyFields().sizeHint(size);
        }

        public void addComparatorField(int fieldId, TypeComparator<?> comparator) {
            this.fieldComparators().$plus$eq(comparator);
            this.logicalKeyFields().$plus$eq((Object)BoxesRunTime.boxToInteger((int)fieldId));
        }

        public TypeComparator<T> createTypeComparator(ExecutionConfig config) {
            int maxIndex = BoxesRunTime.unboxToInt((Object)this.logicalKeyFields().max((Ordering)Ordering.Int$.MODULE$));
            Object object = Predef$.MODULE$.refArrayOps((Object[])CaseClassTypeInfo.this.protected$types());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(object, maxIndex + 1));
            return new CaseClassComparator((int[])this.logicalKeyFields().toArray(ClassTag$.MODULE$.apply(Integer.TYPE)), (TypeComparator[])this.fieldComparators().toArray(ClassTag$.MODULE$.apply(TypeComparator.class)), (TypeSerializer[])ArrayOps$.MODULE$.map$extension(object2, arg_0 -> CaseClassTypeInfo.org$apache$flinkx$api$typeinfo$CaseClassTypeInfo$CaseClassTypeComparatorBuilder$$_$createTypeComparator$$anonfun$1(config, arg_0), ClassTag$.MODULE$.apply(TypeSerializer.class)));
        }

        public final /* synthetic */ CaseClassTypeInfo org$apache$flinkx$api$typeinfo$CaseClassTypeInfo$CaseClassTypeComparatorBuilder$$$outer() {
            return CaseClassTypeInfo.this;
        }
    }
}

