/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flinkx.api.serializer.CollectionSerializerSnapshot;
import org.apache.flinkx.api.serializer.SimpleSerializer;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;

public class VectorSerializer<T>
extends TypeSerializerSingleton<Vector<T>>
implements SimpleSerializer<Vector<T>> {
    private final TypeSerializer<T> child;
    private final Class<T> clazz;

    public VectorSerializer(TypeSerializer<T> child, Class<T> clazz) {
        this.child = child;
        this.clazz = clazz;
    }

    public Vector<T> createInstance() {
        return package$.MODULE$.Vector().empty();
    }

    public int getLength() {
        return -1;
    }

    public Vector<T> deserialize(DataInputView source) {
        int count = source.readInt();
        IndexedSeq result = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)x$1 -> this.$anonfun$1(source, BoxesRunTime.unboxToInt((Object)x$1)));
        return result.toVector();
    }

    public void serialize(Vector<T> record, DataOutputView target) {
        target.writeInt(record.size());
        record.foreach((Function1)(JProcedure1 & Serializable)element -> this.child.serialize(element, target));
    }

    public TypeSerializerSnapshot<Vector<T>> snapshotConfiguration() {
        return new CollectionSerializerSnapshot(this.child, VectorSerializer.class, this.clazz);
    }

    private final /* synthetic */ Object $anonfun$1(DataInputView source$1, int x$1) {
        int n = x$1;
        return this.child.deserialize(source$1);
    }
}

