/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.typeutils;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.streaming.util.typeutils.FieldAccessor;
import org.apache.flink.streaming.util.typeutils.ScalaProductFieldAccessorFactory;
import org.apache.flink.util.Preconditions;
import scala.Product;

public class DefaultScalaProductFieldAccessorFactory
implements ScalaProductFieldAccessorFactory {
    public <T, F> FieldAccessor<T, F> createSimpleProductFieldAccessor(int n, TypeInformation<T> typeInformation, ExecutionConfig executionConfig) {
        return new SimpleProductFieldAccessor(n, typeInformation, executionConfig);
    }

    public <T, R, F> FieldAccessor<T, F> createRecursiveProductFieldAccessor(int n, TypeInformation<T> typeInformation, FieldAccessor<R, F> fieldAccessor, ExecutionConfig executionConfig) {
        return new RecursiveProductFieldAccessor<T, R, F>(n, typeInformation, fieldAccessor, executionConfig);
    }

    private static final class RecursiveProductFieldAccessor<T, R, F>
    extends FieldAccessor<T, F> {
        private static final long serialVersionUID = 1L;
        private final int pos;
        private final TupleSerializerBase<T> serializer;
        private final Object[] fields;
        private final int length;
        private final FieldAccessor<R, F> innerAccessor;

        RecursiveProductFieldAccessor(int n, TypeInformation<T> typeInformation, FieldAccessor<R, F> fieldAccessor, ExecutionConfig executionConfig) {
            int n2 = ((TupleTypeInfoBase)typeInformation).getArity();
            if (n < 0 || n >= n2) {
                throw new CompositeType.InvalidFieldReferenceException("Tried to select " + Integer.valueOf(n).toString() + ". field on \"" + typeInformation.toString() + "\", which is an invalid index.");
            }
            Preconditions.checkNotNull(typeInformation, (String)"typeInfo must not be null.");
            Preconditions.checkNotNull(fieldAccessor, (String)"innerAccessor must not be null.");
            this.pos = n;
            this.serializer = (TupleSerializerBase)typeInformation.createSerializer(executionConfig);
            this.length = this.serializer.getArity();
            this.fields = new Object[this.length];
            this.innerAccessor = fieldAccessor;
            this.fieldType = fieldAccessor.getFieldType();
        }

        public F get(T t) {
            return (F)this.innerAccessor.get(((Product)t).productElement(this.pos));
        }

        public T set(T t, F f) {
            Product product = (Product)t;
            for (int i = 0; i < this.length; ++i) {
                this.fields[i] = product.productElement(i);
            }
            this.fields[this.pos] = this.innerAccessor.set(this.fields[this.pos], f);
            return (T)this.serializer.createInstance(this.fields);
        }
    }

    private static final class SimpleProductFieldAccessor<T, F>
    extends FieldAccessor<T, F> {
        private static final long serialVersionUID = 1L;
        private final int pos;
        private final TupleSerializerBase<T> serializer;
        private final Object[] fields;
        private final int length;

        SimpleProductFieldAccessor(int n, TypeInformation<T> typeInformation, ExecutionConfig executionConfig) {
            Preconditions.checkNotNull(typeInformation, (String)"typeInfo must not be null.");
            int n2 = ((TupleTypeInfoBase)typeInformation).getArity();
            if (n < 0 || n >= n2) {
                throw new CompositeType.InvalidFieldReferenceException("Tried to select " + Integer.valueOf(n).toString() + ". field on \"" + typeInformation.toString() + "\", which is an invalid index.");
            }
            this.pos = n;
            this.fieldType = ((TupleTypeInfoBase)typeInformation).getTypeAt(n);
            this.serializer = (TupleSerializerBase)typeInformation.createSerializer(executionConfig);
            this.length = this.serializer.getArity();
            this.fields = new Object[this.length];
        }

        public F get(T t) {
            Product product = (Product)t;
            return (F)product.productElement(this.pos);
        }

        public T set(T t, F f) {
            Product product = (Product)t;
            for (int i = 0; i < this.length; ++i) {
                this.fields[i] = product.productElement(i);
            }
            this.fields[this.pos] = f;
            return (T)this.serializer.createInstance(this.fields);
        }
    }
}

