/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.serializer;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.api.serializer.MappedSerializer$;
import org.apache.flink.api.serializer.SimpleSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import scala.Product;
import scala.runtime.BoxesRunTime;

public class MappedSerializer<A, B>
extends TypeSerializerSingleton<A>
implements SimpleSerializer<A>,
Product {
    private final TypeMapper mapper;
    private final TypeSerializer ser;

    public static <A, B> MappedSerializer<A, B> apply(TypeMapper<A, B> typeMapper, TypeSerializer<B> typeSerializer) {
        return MappedSerializer$.MODULE$.apply(typeMapper, typeSerializer);
    }

    public static MappedSerializer<?, ?> fromProduct(Product product) {
        return MappedSerializer$.MODULE$.fromProduct(product);
    }

    public static <A, B> MappedSerializer<A, B> unapply(MappedSerializer<A, B> mappedSerializer) {
        return MappedSerializer$.MODULE$.unapply(mappedSerializer);
    }

    public MappedSerializer(TypeMapper<A, B> mapper, TypeSerializer<B> ser) {
        this.mapper = mapper;
        this.ser = ser;
    }

    public boolean canEqual(Object that) {
        return that instanceof MappedSerializer;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "MappedSerializer";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "mapper";
        }
        if (1 == n2) {
            return "ser";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public TypeMapper<A, B> mapper() {
        return this.mapper;
    }

    public TypeSerializer<B> ser() {
        return this.ser;
    }

    public boolean equals(Object obj) {
        return this.ser().equals(obj);
    }

    public String toString() {
        return this.ser().toString();
    }

    public int hashCode() {
        return this.ser().hashCode();
    }

    public int getLength() {
        return this.ser().getLength();
    }

    public void serialize(A record, DataOutputView target) {
        this.ser().serialize(this.mapper().map(record), target);
    }

    @Override
    public A deserialize(A reuse, DataInputView source) {
        return this.mapper().contramap(this.ser().deserialize(this.mapper().map(reuse), source));
    }

    public A deserialize(DataInputView source) {
        return this.mapper().contramap(this.ser().deserialize(source));
    }

    public TypeSerializerSnapshot<A> snapshotConfiguration() {
        return new MappedSerializerSnapshot<A, B>(this.mapper(), this.ser());
    }

    public A createInstance() {
        return this.mapper().contramap(this.ser().createInstance());
    }

    @Override
    public <A, B> MappedSerializer<A, B> copy(TypeMapper<A, B> mapper, TypeSerializer<B> ser) {
        return new MappedSerializer<A, B>(mapper, ser);
    }

    public <A, B> TypeMapper<A, B> copy$default$1() {
        return this.mapper();
    }

    public <A, B> TypeSerializer<B> copy$default$2() {
        return this.ser();
    }

    public TypeMapper<A, B> _1() {
        return this.mapper();
    }

    public TypeSerializer<B> _2() {
        return this.ser();
    }

    public static class MappedSerializerSnapshot<A, B>
    implements TypeSerializerSnapshot<A> {
        private TypeMapper mapper;
        private TypeSerializer ser;

        public MappedSerializerSnapshot() {
        }

        public TypeMapper<A, B> mapper() {
            return this.mapper;
        }

        public void mapper_$eq(TypeMapper<A, B> x$1) {
            this.mapper = x$1;
        }

        public TypeSerializer<B> ser() {
            return this.ser;
        }

        public void ser_$eq(TypeSerializer<B> x$1) {
            this.ser = x$1;
        }

        public MappedSerializerSnapshot(TypeMapper<A, B> xmapper, TypeSerializer<B> xser) {
            this();
            this.mapper_$eq(xmapper);
            this.ser_$eq(xser);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) {
            Class mapperClazz = InstantiationUtil.resolveClassByName((DataInputView)in, (ClassLoader)userCodeClassLoader);
            this.mapper_$eq((TypeMapper)InstantiationUtil.instantiate((Class)mapperClazz));
            Class serClazz = InstantiationUtil.resolveClassByName((DataInputView)in, (ClassLoader)userCodeClassLoader);
            this.ser_$eq((TypeSerializer)InstantiationUtil.instantiate((Class)serClazz));
        }

        public TypeSerializerSchemaCompatibility<A> resolveSchemaCompatibility(TypeSerializer<A> newSerializer) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }

        public void writeSnapshot(DataOutputView out) {
            out.writeUTF(this.mapper().getClass().getName());
            out.writeUTF(this.ser().getClass().getName());
        }

        public TypeSerializer<A> restoreSerializer() {
            return new MappedSerializer<A, B>(this.mapper(), this.ser());
        }

        public int getCurrentVersion() {
            return 1;
        }
    }

    public static interface TypeMapper<A, B> {
        public B map(A var1);

        public A contramap(B var1);
    }
}

