/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.serializer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.serializer.ScalaEitherSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import scala.MatchError;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Internal
public class EitherSerializer<A, B>
extends TypeSerializer<Either<A, B>> {
    private static final long serialVersionUID = 9219995873023657525L;
    private final TypeSerializer leftSerializer;
    private final TypeSerializer rightSerializer;

    public EitherSerializer(TypeSerializer<A> leftSerializer, TypeSerializer<B> rightSerializer) {
        this.leftSerializer = leftSerializer;
        this.rightSerializer = rightSerializer;
    }

    public TypeSerializer<A> leftSerializer() {
        return this.leftSerializer;
    }

    public TypeSerializer<B> rightSerializer() {
        return this.rightSerializer;
    }

    public EitherSerializer<A, B> duplicate() {
        TypeSerializer leftDup = this.leftSerializer().duplicate();
        TypeSerializer rightDup = this.rightSerializer().duplicate();
        if (leftDup == this.leftSerializer() && rightDup == this.rightSerializer()) {
            return this;
        }
        return new EitherSerializer<A, B>(leftDup, rightDup);
    }

    public Either<A, B> createInstance() {
        return package$.MODULE$.Left().apply(null);
    }

    public boolean isImmutableType() {
        return !(this.leftSerializer() != null && !this.leftSerializer().isImmutableType() || this.rightSerializer() != null && !this.rightSerializer().isImmutableType());
    }

    public int getLength() {
        return -1;
    }

    public Either<A, B> copy(Either<A, B> from) {
        Either<A, B> either = from;
        if (either instanceof Left) {
            Object a = ((Left)either).value();
            return package$.MODULE$.Left().apply(this.leftSerializer().copy(a));
        }
        if (either instanceof Right) {
            Object b = ((Right)either).value();
            return package$.MODULE$.Right().apply(this.rightSerializer().copy(b));
        }
        throw new MatchError(either);
    }

    public Either<A, B> copy(Either<A, B> from, Either<A, B> reuse) {
        return this.copy(from);
    }

    public void copy(DataInputView source, DataOutputView target) {
        boolean isLeft = source.readBoolean();
        target.writeBoolean(isLeft);
        if (isLeft) {
            this.leftSerializer().copy(source, target);
            return;
        }
        this.rightSerializer().copy(source, target);
    }

    public void serialize(Either<A, B> either, DataOutputView target) {
        Either<A, B> either2 = either;
        if (either2 instanceof Left) {
            Object a = ((Left)either2).value();
            target.writeBoolean(true);
            this.leftSerializer().serialize(a, target);
            return;
        }
        if (either2 instanceof Right) {
            Object b = ((Right)either2).value();
            target.writeBoolean(false);
            this.rightSerializer().serialize(b, target);
            return;
        }
        throw new MatchError(either2);
    }

    public Either<A, B> deserialize(DataInputView source) {
        boolean isLeft = source.readBoolean();
        if (isLeft) {
            return package$.MODULE$.Left().apply(this.leftSerializer().deserialize(source));
        }
        return package$.MODULE$.Right().apply(this.rightSerializer().deserialize(source));
    }

    public Either<A, B> deserialize(Either<A, B> reuse, DataInputView source) {
        boolean isLeft = source.readBoolean();
        if (isLeft) {
            return package$.MODULE$.Left().apply(this.leftSerializer().deserialize(source));
        }
        return package$.MODULE$.Right().apply(this.rightSerializer().deserialize(source));
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof EitherSerializer) {
            EitherSerializer eitherSerializer = (EitherSerializer)((Object)object);
            return this.leftSerializer().equals(eitherSerializer.leftSerializer()) && this.rightSerializer().equals(eitherSerializer.rightSerializer());
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.leftSerializer().hashCode() + this.rightSerializer().hashCode();
    }

    public TypeSerializer<A> getLeftSerializer() {
        return this.leftSerializer();
    }

    public TypeSerializer<B> getRightSerializer() {
        return this.rightSerializer();
    }

    public ScalaEitherSerializerSnapshot<A, B> snapshotConfiguration() {
        return new ScalaEitherSerializerSnapshot(this);
    }
}

