/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.NullFieldException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Internal
public abstract class CaseClassSerializer<T extends Product>
extends TupleSerializerBase<T>
implements Cloneable {
    private static final long serialVersionUID = 7341356073446263475L;
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CaseClassSerializer.class.getDeclaredField("log$lzy1"));
    private final TypeSerializer<?>[] scalaFieldSerializers;
    private volatile transient Object log$lzy1;

    public CaseClassSerializer(Class<T> clazz, TypeSerializer<?>[] scalaFieldSerializers) {
        this.scalaFieldSerializers = scalaFieldSerializers;
        super(clazz, scalaFieldSerializers);
    }

    public Logger log() {
        Object object = this.log$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((Class)this.getClass());
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean isImmutableType() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.scalaFieldSerializers);
        return ArrayOps$.MODULE$.forall$extension(object, (Function1 & Serializable)_$1 -> _$1.isImmutableType());
    }

    public CaseClassSerializer<T> duplicate() {
        return (CaseClassSerializer)this.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        CaseClassSerializer result = (CaseClassSerializer)super.clone();
        Object object = Predef$.MODULE$.refArrayOps((Object[])result.fieldSerializers);
        result.fieldSerializers = (TypeSerializer[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> _$2.duplicate(), ClassTag$.MODULE$.apply(TypeSerializer.class));
        return result;
    }

    public T createInstance() {
        Product product;
        try {
            IndexedSeq fields = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.arity).map((Function1 & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
            product = (Product)this.createInstance((Object[])fields.toArray(ClassTag$.MODULE$.apply(Object.class)));
        }
        catch (Throwable t) {
            this.log().warn("Failed to create an instance returning null", t);
            product = null;
        }
        return (T)product;
    }

    public T createOrReuseInstance(Object[] fields, T reuse) {
        return (T)((Product)this.createInstance(fields));
    }

    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    public T copy(T from) {
        if (from == null) {
            return null;
        }
        IndexedSeq fields = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.arity).map((Function1 & Serializable)i -> this.$anonfun$2((Product)from, BoxesRunTime.unboxToInt((Object)i)));
        return (T)((Product)this.createInstance((Object[])fields.toArray(ClassTag$.MODULE$.apply(Object.class))));
    }

    private boolean isClassArityUsageDisabled() {
        return package$.MODULE$.env().contains((Object)"DISABLE_CASE_CLASS_ARITY_USAGE");
    }

    public void serialize(T value, DataOutputView target) {
        if (this.arity > 0 && !this.isClassArityUsageDisabled()) {
            target.writeInt(value.productArity());
        }
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.arity).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            TypeSerializer serializer = this.fieldSerializers[i];
            Object o = value.productElement(i);
            try {
                serializer.serialize(o, target);
            }
            catch (NullPointerException e) {
                throw new NullFieldException(i, (Throwable)e);
            }
        });
    }

    public T deserialize(T reuse, DataInputView source) {
        return this.deserializeFromSource(source, this.isClassArityUsageDisabled());
    }

    public T deserialize(DataInputView source) {
        return this.deserializeFromSource(source, this.isClassArityUsageDisabled());
    }

    public T deserializeFromSource(DataInputView source, boolean classArityUsageDisabled) {
        IntRef i = IntRef.create((int)0);
        boolean fieldFound = true;
        int sourceArity = this.arity > 0 && !classArityUsageDisabled ? BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply(() -> CaseClassSerializer.$anonfun$3(source)).getOrElse(this::$anonfun$4)) : this.arity;
        Object[] fields = new Object[this.arity];
        while (i.elem < sourceArity && fieldFound) {
            int n;
            Try try_ = Try$.MODULE$.apply(() -> this.deserializeFromSource$$anonfun$1(i, source));
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.log().warn(new StringBuilder(39).append("Failed to deserialize field at '").append(i.elem).append("' index").toString(), e);
                fieldFound = false;
            } else if (try_ instanceof Success) {
                Object value;
                fields[i.elem] = value = ((Success)try_).value();
            } else {
                throw new MatchError((Object)try_);
            }
            i.elem = n = i.elem + 1;
        }
        Object object = Predef$.MODULE$.refArrayOps(fields);
        return (T)((Product)this.createInstance((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$3 -> _$3 != null)));
    }

    private final /* synthetic */ Object $anonfun$1(int i) {
        return this.fieldSerializers[i].createInstance();
    }

    private final /* synthetic */ Object $anonfun$2(Product from$1, int i) {
        return this.fieldSerializers[i].copy(from$1.productElement(i));
    }

    private static final int $anonfun$3(DataInputView source$1) {
        return source$1.readInt();
    }

    private final int $anonfun$4() {
        return this.arity;
    }

    private final Object deserializeFromSource$$anonfun$1(IntRef i$1, DataInputView source$2) {
        return this.fieldSerializers[i$1.elem].deserialize(source$2);
    }
}

