/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;

public class CoproductSerializer<T>
extends TypeSerializerSingleton<T> {
    private final Class<?>[] subtypeClasses;
    private final TypeSerializer<?>[] subtypeSerializers;

    public CoproductSerializer(Class<?>[] subtypeClasses, TypeSerializer<?>[] subtypeSerializers) {
        this.subtypeClasses = subtypeClasses;
        this.subtypeSerializers = subtypeSerializers;
    }

    public boolean isImmutableType() {
        return true;
    }

    public T copy(T from) {
        return from;
    }

    public T copy(T from, T reuse) {
        return from;
    }

    public void copy(DataInputView source, DataOutputView target) {
        this.serialize(this.deserialize(source), target);
    }

    public T createInstance() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.subtypeSerializers);
        return (T)((TypeSerializer)ArrayOps$.MODULE$.head$extension(object)).createInstance();
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T record, DataOutputView target) {
        int subtypeIndex = 0;
        boolean found = false;
        while (!found && subtypeIndex < this.subtypeClasses.length) {
            if (this.subtypeClasses[subtypeIndex].isInstance(record)) {
                found = true;
                continue;
            }
            ++subtypeIndex;
        }
        if (found) {
            target.writeByte((int)((byte)subtypeIndex));
            this.subtypeSerializers[subtypeIndex].serialize(record, target);
            return;
        }
        throw new IllegalStateException("subtype not found in sealed trait schema");
    }

    public T deserialize(DataInputView source) {
        byte index = source.readByte();
        TypeSerializer<?> subtype = this.subtypeSerializers[index];
        return (T)subtype.deserialize(source);
    }

    public T deserialize(T reuse, DataInputView source) {
        return this.deserialize(source);
    }

    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new CoproductSerializerSnapshot(this.subtypeClasses, this.subtypeSerializers);
    }

    public static class CoproductSerializerSnapshot<T>
    implements TypeSerializerSnapshot<T> {
        private Class[] subtypeClasses;
        private TypeSerializer[] subtypeSerializers;

        public CoproductSerializerSnapshot(Class<?>[] subtypeClasses, TypeSerializer<?>[] subtypeSerializers) {
            this.subtypeClasses = subtypeClasses;
            this.subtypeSerializers = subtypeSerializers;
        }

        public Class<?>[] subtypeClasses() {
            return this.subtypeClasses;
        }

        public void subtypeClasses_$eq(Class<?>[] x$1) {
            this.subtypeClasses = x$1;
        }

        public TypeSerializer<?>[] subtypeSerializers() {
            return this.subtypeSerializers;
        }

        public void subtypeSerializers_$eq(TypeSerializer<?>[] x$1) {
            this.subtypeSerializers = x$1;
        }

        public CoproductSerializerSnapshot() {
            this((Class[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Class.class)), (TypeSerializer[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(TypeSerializer.class)));
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) {
            int len = in.readInt();
            this.subtypeClasses_$eq((Class[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable)_$1 -> this.readSnapshot$$anonfun$1(in, userCodeClassLoader, BoxesRunTime.unboxToInt((Object)_$1))).toArray(ClassTag$.MODULE$.apply(Class.class)));
            this.subtypeSerializers_$eq((TypeSerializer[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable)_$2 -> this.readSnapshot$$anonfun$2(in, userCodeClassLoader, BoxesRunTime.unboxToInt((Object)_$2))).toArray(ClassTag$.MODULE$.apply(TypeSerializer.class)));
        }

        public int getCurrentVersion() {
            return 1;
        }

        public void writeSnapshot(DataOutputView out) {
            out.writeInt(this.subtypeClasses().length);
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.subtypeClasses());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)c -> out.writeUTF(c.getName()));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.subtypeSerializers());
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)s -> {
                TypeSerializerSnapshot snap = s.snapshotConfiguration();
                out.writeUTF(snap.getClass().getName());
                snap.writeSnapshot(out);
            });
        }

        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }

        public TypeSerializer<T> restoreSerializer() {
            return new CoproductSerializer(this.subtypeClasses(), this.subtypeSerializers());
        }

        private final /* synthetic */ Class readSnapshot$$anonfun$1(DataInputView in$1, ClassLoader userCodeClassLoader$1, int _$1) {
            return InstantiationUtil.resolveClassByName((DataInputView)in$1, (ClassLoader)userCodeClassLoader$1);
        }

        private final /* synthetic */ TypeSerializer readSnapshot$$anonfun$2(DataInputView in$2, ClassLoader userCodeClassLoader$2, int _$2) {
            Class clazz = InstantiationUtil.resolveClassByName((DataInputView)in$2, (ClassLoader)userCodeClassLoader$2);
            TypeSerializerSnapshot serializer = (TypeSerializerSnapshot)InstantiationUtil.instantiate((Class)clazz);
            serializer.readSnapshot(serializer.getCurrentVersion(), in$2, userCodeClassLoader$2);
            return serializer.restoreSerializer();
        }
    }
}

