/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api.serializer;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.NullFieldException;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;

@Internal
public abstract class CaseClassSerializer<T extends Product>
extends TupleSerializerBase<T>
implements Cloneable {
    private static final long serialVersionUID = 7341356073446263475L;
    private transient Object[] fields;
    private transient boolean instanceCreationFailed = false;

    public CaseClassSerializer(Class<T> clazz, TypeSerializer<?>[] scalaFieldSerializers) {
        super(clazz, scalaFieldSerializers);
    }

    public Object[] fields() {
        return this.fields;
    }

    public void fields_$eq(Object[] x$1) {
        this.fields = x$1;
    }

    public boolean instanceCreationFailed() {
        return this.instanceCreationFailed;
    }

    public void instanceCreationFailed_$eq(boolean x$1) {
        this.instanceCreationFailed = x$1;
    }

    public CaseClassSerializer<T> duplicate() {
        return (CaseClassSerializer)this.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        CaseClassSerializer result = (CaseClassSerializer)super.clone();
        Object object = Predef$.MODULE$.refArrayOps((Object[])result.fieldSerializers);
        result.fieldSerializers = (TypeSerializer[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> _$2.duplicate(), ClassTag$.MODULE$.apply(TypeSerializer.class));
        result.fields_$eq(null);
        result.instanceCreationFailed_$eq(false);
        return result;
    }

    public T createInstance() {
        Product product;
        if (this.instanceCreationFailed()) {
            return null;
        }
        this.initArray();
        try {
            for (int i = 0; i < this.arity; ++i) {
                this.fields()[i] = this.fieldSerializers[i].createInstance();
            }
            product = (Product)this.createInstance(this.fields());
        }
        catch (Throwable throwable) {
            this.instanceCreationFailed_$eq(true);
            product = null;
        }
        return (T)product;
    }

    public T createOrReuseInstance(Object[] fields, T reuse) {
        return (T)((Product)this.createInstance(fields));
    }

    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    public T copy(T from) {
        if (from == null) {
            return null;
        }
        this.initArray();
        for (int i = 0; i < this.arity; ++i) {
            this.fields()[i] = this.fieldSerializers[i].copy(from.productElement(i));
        }
        return (T)((Product)this.createInstance(this.fields()));
    }

    public void serialize(T value, DataOutputView target) {
        for (int i = 0; i < this.arity; ++i) {
            TypeSerializer serializer = this.fieldSerializers[i];
            Object o = value.productElement(i);
            try {
                serializer.serialize(o, target);
                continue;
            }
            catch (NullPointerException e) {
                throw new NullFieldException(i, (Throwable)e);
            }
        }
    }

    public T deserialize(T reuse, DataInputView source) {
        return this.deserialize(source);
    }

    public T deserialize(DataInputView source) {
        this.initArray();
        for (int i = 0; i < this.arity; ++i) {
            this.fields()[i] = this.fieldSerializers[i].deserialize(source);
        }
        return (T)((Product)this.createInstance(this.fields()));
    }

    public void initArray() {
        if (this.fields() == null) {
            this.fields_$eq(new Object[this.arity]);
            return;
        }
    }
}

