/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flinkx.api;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;
import org.apache.flinkx.api.DataStream;
import org.apache.flinkx.api.OutputTag;
import org.apache.flinkx.api.ScalaStreamOps$;
import org.apache.flinkx.api.StreamExecutionEnvironment;
import org.apache.flinkx.api.function.ProcessWindowFunction;
import org.apache.flinkx.api.function.WindowFunction;
import org.apache.flinkx.api.function.util.ScalaProcessWindowFunctionWrapper;
import org.apache.flinkx.api.function.util.ScalaReduceFunction;
import org.apache.flinkx.api.function.util.ScalaWindowFunction;
import org.apache.flinkx.api.function.util.ScalaWindowFunctionWrapper;
import scala.Function2;
import scala.Function4;
import scala.Predef$;
import scala.collection.Iterable;
import scala.runtime.BoxedUnit;

@Public
public class WindowedStream<T, K, W extends Window> {
    private final org.apache.flink.streaming.api.datastream.WindowedStream<T, K, W> javaStream;

    public WindowedStream(org.apache.flink.streaming.api.datastream.WindowedStream<T, K, W> javaStream) {
        this.javaStream = javaStream;
    }

    @PublicEvolving
    public WindowedStream<T, K, W> allowedLateness(Time lateness) {
        this.javaStream.allowedLateness(lateness);
        return this;
    }

    @PublicEvolving
    public WindowedStream<T, K, W> sideOutputLateData(OutputTag<T> outputTag) {
        this.javaStream.sideOutputLateData(outputTag);
        return this;
    }

    @PublicEvolving
    public WindowedStream<T, K, W> trigger(Trigger<? super T, ? super W> trigger) {
        this.javaStream.trigger(trigger);
        return this;
    }

    @PublicEvolving
    public WindowedStream<T, K, W> evictor(Evictor<? super T, ? super W> evictor) {
        this.javaStream.evictor(evictor);
        return this;
    }

    public DataStream<T> reduce(ReduceFunction<T> function) {
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(this.clean(function)));
    }

    public DataStream<T> reduce(Function2<T, T, T> function) {
        if (function == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        Function2<T, T, T> cleanFun = this.clean(function);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanFun);
        return this.reduce(reducer);
    }

    public <R> DataStream<R> reduce(ReduceFunction<T> preAggregator, WindowFunction<T, R, K, W> function, TypeInformation<R> evidence$1) {
        ReduceFunction<T> cleanedPreAggregator = this.clean(preAggregator);
        WindowFunction<T, R, K, W> cleanedWindowFunction = this.clean(function);
        ScalaWindowFunctionWrapper<T, R, K, W> applyFunction = new ScalaWindowFunctionWrapper<T, R, K, W>(cleanedWindowFunction);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$1);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(cleanedPreAggregator, applyFunction, resultType));
    }

    public <R> DataStream<R> reduce(Function2<T, T, T> preAggregator, Function4<K, W, Iterable<T>, Collector<R>, BoxedUnit> windowFunction, TypeInformation<R> evidence$2) {
        if (preAggregator == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        if (windowFunction == null) {
            throw new NullPointerException("WindowApply function must not be null.");
        }
        Function2<T, T, T> cleanReducer = this.clean(preAggregator);
        Function4<K, W, Iterable<T>, Collector<R>, BoxedUnit> cleanWindowFunction = this.clean(windowFunction);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanReducer);
        ScalaWindowFunction<T, R, K, W> applyFunction = new ScalaWindowFunction<T, R, K, W>(cleanWindowFunction);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(reducer, applyFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$2)));
    }

    @PublicEvolving
    public <R> DataStream<R> reduce(Function2<T, T, T> preAggregator, ProcessWindowFunction<T, R, K, W> function, TypeInformation<R> evidence$3) {
        Function2<T, T, T> cleanedPreAggregator = this.clean(preAggregator);
        ProcessWindowFunction<T, R, K, W> cleanedWindowFunction = this.clean((Object)function);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanedPreAggregator);
        ScalaProcessWindowFunctionWrapper<T, R, K, W> applyFunction = new ScalaProcessWindowFunctionWrapper<T, R, K, W>(cleanedWindowFunction);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$3);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(reducer, applyFunction, resultType));
    }

    @PublicEvolving
    public <R> DataStream<R> reduce(ReduceFunction<T> preAggregator, ProcessWindowFunction<T, R, K, W> function, TypeInformation<R> evidence$4) {
        ReduceFunction<T> cleanedPreAggregator = this.clean(preAggregator);
        ProcessWindowFunction<T, R, K, W> cleanedWindowFunction = this.clean((Object)function);
        ScalaProcessWindowFunctionWrapper<T, R, K, W> applyFunction = new ScalaProcessWindowFunctionWrapper<T, R, K, W>(cleanedWindowFunction);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$4);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.reduce(cleanedPreAggregator, applyFunction, resultType));
    }

    @PublicEvolving
    public <ACC, R> DataStream<R> aggregate(AggregateFunction<T, ACC, R> aggregateFunction, TypeInformation<ACC> evidence$5, TypeInformation<R> evidence$6) {
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$5);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$6);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.aggregate(this.clean(aggregateFunction), accumulatorType, resultType));
    }

    @PublicEvolving
    public <ACC, V, R> DataStream<R> aggregate(AggregateFunction<T, ACC, V> preAggregator, WindowFunction<V, R, K, W> windowFunction, TypeInformation<ACC> evidence$7, TypeInformation<V> evidence$8, TypeInformation<R> evidence$9) {
        AggregateFunction<T, ACC, V> cleanedPreAggregator = this.clean(preAggregator);
        WindowFunction<V, R, K, W> cleanedWindowFunction = this.clean(windowFunction);
        ScalaWindowFunctionWrapper<V, R, K, W> applyFunction = new ScalaWindowFunctionWrapper<V, R, K, W>(cleanedWindowFunction);
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$7);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$9);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.aggregate(cleanedPreAggregator, applyFunction, accumulatorType, resultType));
    }

    @PublicEvolving
    public <ACC, V, R> DataStream<R> aggregate(AggregateFunction<T, ACC, V> preAggregator, Function4<K, W, Iterable<V>, Collector<R>, BoxedUnit> windowFunction, TypeInformation<ACC> evidence$10, TypeInformation<V> evidence$11, TypeInformation<R> evidence$12) {
        AggregateFunction<T, ACC, V> cleanedPreAggregator = this.clean(preAggregator);
        Function4<K, W, Iterable<V>, Collector<R>, BoxedUnit> cleanedWindowFunction = this.clean(windowFunction);
        ScalaWindowFunction<V, R, K, W> applyFunction = new ScalaWindowFunction<V, R, K, W>(cleanedWindowFunction);
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$10);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$12);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.aggregate(cleanedPreAggregator, applyFunction, accumulatorType, resultType));
    }

    @PublicEvolving
    public <ACC, V, R> DataStream<R> aggregate(AggregateFunction<T, ACC, V> preAggregator, ProcessWindowFunction<V, R, K, W> windowFunction, TypeInformation<ACC> evidence$13, TypeInformation<V> evidence$14, TypeInformation<R> evidence$15) {
        AggregateFunction<T, ACC, V> cleanedPreAggregator = this.clean(preAggregator);
        ProcessWindowFunction<V, R, K, W> cleanedWindowFunction = this.clean((Object)windowFunction);
        ScalaProcessWindowFunctionWrapper<V, R, K, W> applyFunction = new ScalaProcessWindowFunctionWrapper<V, R, K, W>(cleanedWindowFunction);
        TypeInformation accumulatorType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$13);
        TypeInformation aggregationResultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$14);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$15);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.aggregate(cleanedPreAggregator, applyFunction, accumulatorType, aggregationResultType, resultType));
    }

    @PublicEvolving
    public <R> DataStream<R> process(ProcessWindowFunction<T, R, K, W> function, TypeInformation<R> evidence$16) {
        ProcessWindowFunction<T, R, K, W> cleanFunction = this.clean((Object)function);
        ScalaProcessWindowFunctionWrapper<T, R, K, W> applyFunction = new ScalaProcessWindowFunctionWrapper<T, R, K, W>(cleanFunction);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.process(applyFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$16)));
    }

    public <R> DataStream<R> apply(WindowFunction<T, R, K, W> function, TypeInformation<R> evidence$17) {
        WindowFunction<T, R, K, W> cleanFunction = this.clean(function);
        ScalaWindowFunctionWrapper<T, R, K, W> applyFunction = new ScalaWindowFunctionWrapper<T, R, K, W>(cleanFunction);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.apply(applyFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$17)));
    }

    public <R> DataStream<R> apply(Function4<K, W, Iterable<T>, Collector<R>, BoxedUnit> function, TypeInformation<R> evidence$18) {
        if (function == null) {
            throw new NullPointerException("WindowApply function must not be null.");
        }
        Function4<K, W, Iterable<T>, Collector<R>, BoxedUnit> cleanedFunction = this.clean(function);
        ScalaWindowFunction<T, R, K, W> applyFunction = new ScalaWindowFunction<T, R, K, W>(cleanedFunction);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.apply(applyFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$18)));
    }

    public <R> DataStream<R> apply(ReduceFunction<T> preAggregator, WindowFunction<T, R, K, W> function, TypeInformation<R> evidence$19) {
        ReduceFunction<T> cleanedPreAggregator = this.clean(preAggregator);
        WindowFunction<T, R, K, W> cleanedWindowFunction = this.clean(function);
        ScalaWindowFunctionWrapper<T, R, K, W> applyFunction = new ScalaWindowFunctionWrapper<T, R, K, W>(cleanedWindowFunction);
        TypeInformation resultType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$19);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.apply(cleanedPreAggregator, applyFunction, resultType));
    }

    public <R> DataStream<R> apply(Function2<T, T, T> preAggregator, Function4<K, W, Iterable<T>, Collector<R>, BoxedUnit> windowFunction, TypeInformation<R> evidence$20) {
        if (preAggregator == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        if (windowFunction == null) {
            throw new NullPointerException("WindowApply function must not be null.");
        }
        Function2<T, T, T> cleanReducer = this.clean(preAggregator);
        Function4<K, W, Iterable<T>, Collector<R>, BoxedUnit> cleanWindowFunction = this.clean(windowFunction);
        ScalaReduceFunction<T> reducer = new ScalaReduceFunction<T>(cleanReducer);
        ScalaWindowFunction<T, R, K, W> applyFunction = new ScalaWindowFunction<T, R, K, W>(cleanWindowFunction);
        return ScalaStreamOps$.MODULE$.asScalaStream(this.javaStream.apply(reducer, applyFunction, (TypeInformation)Predef$.MODULE$.implicitly(evidence$20)));
    }

    public DataStream<T> max(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, position);
    }

    public DataStream<T> max(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, field);
    }

    public DataStream<T> min(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, position);
    }

    public DataStream<T> min(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, field);
    }

    public DataStream<T> sum(int position) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, position);
    }

    public DataStream<T> sum(String field) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, field);
    }

    public DataStream<T> maxBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, position);
    }

    public DataStream<T> maxBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, field);
    }

    public DataStream<T> minBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, position);
    }

    public DataStream<T> minBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, field);
    }

    private DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, String field) {
        int position = ScalaStreamOps$.MODULE$.fieldNames2Indices(this.getInputType(), new String[]{field})[0];
        return this.aggregate(aggregationType, position);
    }

    public DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, int position) {
        org.apache.flink.streaming.api.datastream.WindowedStream<T, K, W> jStream = this.javaStream;
        AggregationFunction.AggregationType aggregationType2 = aggregationType;
        AggregationFunction.AggregationType aggregationType3 = AggregationFunction.AggregationType.SUM;
        AggregationFunction.AggregationType aggregationType4 = aggregationType2;
        SumAggregator reducer = !(aggregationType3 != null ? !aggregationType3.equals(aggregationType4) : aggregationType4 != null) ? new SumAggregator(position, jStream.getInputType(), jStream.getExecutionEnvironment().getConfig()) : new ComparableAggregator(position, jStream.getInputType(), aggregationType, true, jStream.getExecutionEnvironment().getConfig());
        return new DataStream(jStream.reduce((ReduceFunction)reducer));
    }

    public <F> F clean(F f) {
        return new StreamExecutionEnvironment(this.javaStream.getExecutionEnvironment()).scalaClean(f);
    }

    private TypeInformation<T> getInputType() {
        return this.javaStream.getInputType();
    }
}

